/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.doc;

import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Module;

public class DotDocGen
extends Generator {
    private static final Logger logger = Logger.getLogger(DotDocGen.class);
    public static final String GRAPHVIZ_COMMAND_WINDOWS = "dot";

    @Override
    public String getDescription() {
        return "Generates one documentation file describing all entities.";
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        this.generate(model, options, false);
    }

    public void generate(Model model, MolgenisOptions options, boolean wait) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            File target = new File(this.getDocumentationPath(options) + "/objectmodel-uml-diagram.dot");
            boolean created = target.getParentFile().mkdirs();
            if (!created && !target.getParentFile().exists()) {
                throw new IOException("could not create " + target.getParentFile());
            }
            List<Entity> entityList = model.getEntities();
            templateArgs.put("model", model);
            templateArgs.put("module", model);
            templateArgs.put("entities", entityList);
            templateArgs.put("skipinterfaces", true);
            templateArgs.put("rendersystem", false);
            this.apply(templateArgs, template, target);
            logger.info((Object)("generated " + target));
            this.executeDot(target, "png", wait);
            for (Module module : model.getModules()) {
                entityList = module.getEntities();
                templateArgs.put("model", model);
                templateArgs.put("module", module);
                templateArgs.put("entities", entityList);
                templateArgs.put("skipinterfaces", false);
                templateArgs.put("rendersystem", false);
                target = new File(this.getDocumentationPath(options) + "/objectmodel-uml-diagram-" + module.getName() + ".dot");
                this.apply(templateArgs, template, target);
                this.executeDot(target, "png", wait);
                logger.info((Object)("generated " + target));
            }
        }
    }

    private void apply(Map<String, Object> templateArgs, Template template, File target) throws IOException, TemplateException {
        FileOutputStream targetOut = new FileOutputStream(target);
        template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
        ((OutputStream)targetOut).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDot(File dotFile, String type, boolean wait) {
        String command = "";
        String result = "";
        try {
            command = command + "dot -T" + type + " -O \"" + dotFile.getAbsolutePath() + "\"";
            String os = System.getProperty("os.name").toLowerCase();
            Process p = os.indexOf("windows 9") > -1 ? Runtime.getRuntime().exec(new String[]{"command.com", "/c", command}) : (os.indexOf("windows") > -1 ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", command}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command}));
            logger.debug((Object)("Executing: " + command));
            if (wait) {
                p.waitFor();
            }
            logger.debug((Object)("Data model image was generated succesfully.\nOutput:\n" + result));
            command = "dot -Tsvg -O \"" + dotFile.getAbsolutePath() + "\"";
            logger.debug((Object)("Executing: " + command));
            p = os.indexOf("windows 9") > -1 ? Runtime.getRuntime().exec(new String[]{"command.com", "/c", command}) : (os.indexOf("windows") > -1 ? Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", command}) : Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command}));
            if (wait) {
                p.waitFor();
            }
            logger.debug((Object)("Data model image was generated succesfully.\nOutput:\n" + result));
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)("Generation of graphical documentation failed: return code " + e.getMessage() + ". Install GraphViz and put dot.exe on your path."));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            logger.error((Object)("Generation of graphical documentation failed: return code " + e.getMessage() + ". Install GraphViz and put dot.exe on your path."));
        }
    }
}

