/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model.elements;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;

public class Unique
implements Serializable {
    private static final long serialVersionUID = -1201614213585052020L;
    private Entity entity;
    private List<String> fields;
    private boolean subclass = false;
    private String description;

    public Unique(Entity entity, String fieldName, boolean subclass, String description) {
        this.entity = entity;
        this.fields = new Vector<String>();
        this.subclass = subclass;
        this.description = description;
        this.fields.add(fieldName);
    }

    public Unique(Unique u) {
        this.description = u.description;
        this.entity = u.entity;
        this.fields = u.fields;
        this.subclass = u.subclass;
    }

    public Unique(Entity entity, List<String> fieldNames, boolean subclass, String description) {
        this.entity = entity;
        this.fields = fieldNames;
        this.subclass = subclass;
        this.description = description;
    }

    public Vector<Field> getFields() throws MolgenisModelException {
        Vector<Field> result = new Vector<Field>();
        for (String fieldName : this.fields) {
            Field f = this.entity.getAllField(fieldName);
            if (f == null) {
                throw new MolgenisModelException("Unknown unique field: " + this.getEntity().getName() + "." + fieldName);
            }
            result.add(f);
        }
        return result;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean isSubclass() {
        return this.subclass;
    }

    public void setSubclass(boolean subclass) {
        this.subclass = subclass;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public String toString() {
        StringBuilder strBuilder = new StringBuilder("Unique(");
        for (String field : this.fields) {
            strBuilder.append(field).append(", ");
        }
        strBuilder.append(')');
        return strBuilder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
        result = 31 * result + (this.fields == null ? 0 : this.fields.hashCode());
        result = 31 * result + (this.subclass ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == Unique.class) {
            return this.toString().equals(((Unique)obj).toString());
        }
        return false;
    }
}

