/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class CaseInsensitiveLinkedHashMap<V>
extends LinkedHashMap<String, V> {
    private static final long serialVersionUID = -5765647414721292250L;
    private final Map<String, String> keyMap = new LinkedHashMap<String, String>();

    @Override
    public V put(String key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.keyMap.put(key.toLowerCase(), key);
        return super.put(key.toLowerCase(), value);
    }

    @Override
    public V remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        String keyStr = ((String)key).toLowerCase();
        this.keyMap.remove(keyStr);
        return super.remove(keyStr);
    }

    @Override
    public V get(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        return super.get(((String)key).toLowerCase());
    }

    @Override
    public Set<String> keySet() {
        Set keys = super.keySet();
        LinkedHashSet originalKeys = Sets.newLinkedHashSetWithExpectedSize((int)keys.size());
        for (String key : keys) {
            originalKeys.add(this.keyMap.get(key));
        }
        return originalKeys;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

