/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtils.class);
    private static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    private ResourceUtils() {
    }

    public static File getFile(String resourceName) {
        URL resourceUrl = Resources.getResource((String)resourceName);
        return ResourceUtils.getFile(resourceUrl);
    }

    public static File getFile(Class<?> contextClass, String resourceName) {
        URL resourceUrl = Resources.getResource(contextClass, (String)resourceName);
        return ResourceUtils.getFile(resourceUrl);
    }

    public static String getString(String resourceName) throws IOException {
        URL resourceUrl = Resources.getResource((String)resourceName);
        return ResourceUtils.getString(resourceUrl, CHARSET_UTF8);
    }

    public static String getString(Class<?> contextClass, String resourceName) throws IOException {
        URL resourceUrl = Resources.getResource(contextClass, (String)resourceName);
        return ResourceUtils.getString(resourceUrl, CHARSET_UTF8);
    }

    public static String getString(Class<?> contextClass, String resourceName, Charset charset) throws IOException {
        URL resourceUrl = Resources.getResource(contextClass, (String)resourceName);
        return ResourceUtils.getString(resourceUrl, charset);
    }

    public static byte[] getBytes(String resourceName) throws IOException {
        URL resourceUrl = Resources.getResource((String)resourceName);
        return ResourceUtils.getBytes(resourceUrl);
    }

    public static byte[] getBytes(Class<?> contextClass, String resourceName) throws IOException {
        URL resourceUrl = Resources.getResource(contextClass, (String)resourceName);
        return ResourceUtils.getBytes(resourceUrl);
    }

    private static File getFile(URL resourceUrl) {
        try {
            return new File(new URI(resourceUrl.toString()).getPath());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (NullPointerException npe) {
            LOG.error("NullPointerException is thrown. Resource url: {} ", (Object)resourceUrl);
            throw new RuntimeException(npe);
        }
    }

    private static String getString(URL resourceUrl, Charset charset) throws IOException {
        return Resources.toString((URL)resourceUrl, (Charset)charset);
    }

    private static byte[] getBytes(URL resourceUrl) throws IOException {
        return Resources.toByteArray((URL)resourceUrl);
    }
}

