/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.MolgenisFieldTypes;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Field;
import org.molgenis.model.elements.Index;
import org.molgenis.model.elements.Matrix;
import org.molgenis.model.elements.Method;
import org.molgenis.model.elements.MethodQuery;
import org.molgenis.model.elements.Model;
import org.molgenis.model.elements.Module;
import org.molgenis.model.elements.Parameter;
import org.molgenis.model.elements.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MolgenisModelParser {
    private static final Logger LOG = LoggerFactory.getLogger(MolgenisModelParser.class);

    public static Entity parseEntity(Model model, Element element) throws MolgenisModelException {
        Element elem;
        int j;
        String _implements;
        String[] keywords = new String[]{"name", "label", "extends", "implements", "abstract", "description", "system", "decorator", "xref_label", "allocationSize", "xref_lookup"};
        ArrayList<String> key_words = new ArrayList<String>(Arrays.asList(keywords));
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            if (key_words.contains(element.getAttributes().item(i).getNodeName())) continue;
            throw new MolgenisModelException("attribute '" + element.getAttributes().item(i).getNodeName() + "' not allowed for <entity>");
        }
        if (element.getAttribute("name").trim().isEmpty()) {
            String message = "name is missing for entity " + element.toString();
            LOG.error(message);
            throw new MolgenisModelException(message);
        }
        Entity entity = new Entity(element.getAttribute("name").trim(), element.getAttribute("label"), model.getDatabase());
        entity.setNamespace(model.getName());
        String _extends = element.getAttribute("extends");
        if (_extends != null) {
            Vector<String> parents = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(_extends, ",");
            while (tokenizer.hasMoreTokens()) {
                parents.add(tokenizer.nextToken().trim());
            }
            entity.setParents(parents);
        }
        if ((_implements = element.getAttribute("implements")) != null && !_implements.isEmpty()) {
            entity.setImplements(new Vector<String>(Arrays.asList(_implements.split(","))));
        }
        entity.setAbstract(Boolean.parseBoolean(element.getAttribute("abstract")));
        entity.setSystem(Boolean.parseBoolean(element.getAttribute("system")));
        String xref_label = element.getAttribute("xref_label");
        if (xref_label != null && !xref_label.isEmpty()) {
            ArrayList<String> xref_labels = new ArrayList<String>();
            xref_labels.addAll(Arrays.asList(xref_label.split(",")));
            entity.setXrefLabels(xref_labels);
        } else {
            entity.setXrefLabels(null);
        }
        String xref_lookup = element.getAttribute("xref_lookup");
        if (xref_lookup != null && !xref_lookup.isEmpty()) {
            ArrayList<String> xref_lookup_fields = new ArrayList<String>();
            xref_lookup_fields.addAll(Arrays.asList(xref_lookup.split(",")));
            entity.setXrefLookupFields(xref_lookup_fields);
        }
        if (element.hasAttribute("decorator")) {
            entity.setDecorator(element.getAttribute("decorator"));
        }
        NodeList elements = element.getElementsByTagName("description");
        for (j = 0; j < elements.getLength(); ++j) {
            entity.setDescription(MolgenisModelParser.elementValueToString((Element)elements.item(j)));
        }
        elements = element.getElementsByTagName("field");
        for (j = 0; j < elements.getLength(); ++j) {
            elem = (Element)elements.item(j);
            MolgenisModelParser.parseField(entity, elem);
        }
        elements = element.getElementsByTagName("unique");
        for (j = 0; j < elements.getLength(); ++j) {
            elem = (Element)elements.item(j);
            Vector<String> keys = new Vector<String>();
            if (elem.hasAttribute("fields")) {
                for (String name : elem.getAttribute("fields").split(",")) {
                    keys.add(name);
                }
            }
            NodeList key_elements = elem.getElementsByTagName("keyfield");
            for (int k = 0; k < key_elements.getLength(); ++k) {
                elem = (Element)key_elements.item(k);
                String name = elem.getAttribute("name");
                keys.add(name);
            }
            String key_description = null;
            if (elem.hasAttribute("description")) {
                key_description = elem.getAttribute("description");
            }
            if (keys.size() == 0) {
                throw new MolgenisModelException("missing fields on unique of '" + entity.getName() + "'. Expected <unique fields=\"field1[,field2,..]\" description=\"...\"/>");
            }
            try {
                entity.addKey(keys, elem.getAttribute("subclass").equals("true"), key_description);
                continue;
            }
            catch (Exception e) {
                throw new MolgenisModelException(e.getMessage());
            }
        }
        elements = element.getElementsByTagName("indices");
        if (elements.getLength() == 1) {
            Element elem2 = (Element)elements.item(0);
            NodeList index_elements = elem2.getElementsByTagName("index");
            for (int k = 0; k < index_elements.getLength(); ++k) {
                elem2 = (Element)index_elements.item(k);
                Index index = new Index(elem2.getAttribute("name"));
                NodeList indexfield_elements = elem2.getElementsByTagName("indexfield");
                for (int l = 0; l < indexfield_elements.getLength(); ++l) {
                    elem2 = (Element)indexfield_elements.item(l);
                    Field f = entity.getField(elem2.getAttribute("name"));
                    if (f == null) {
                        throw new MolgenisModelException("Missing index field: " + elem2.getAttribute("name"));
                    }
                    try {
                        index.addField(elem2.getAttribute("name"));
                        continue;
                    }
                    catch (Exception e) {
                        throw new MolgenisModelException(e.getMessage());
                    }
                }
                try {
                    entity.addIndex(index);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } else if (elements.getLength() > 1) {
            throw new MolgenisModelException("Multiple indices elements");
        }
        if (element.hasAttribute("allocationSize")) {
            int allocationSize = Integer.parseInt(element.getAttribute("allocationSize"));
            entity.setAllocationSize(allocationSize);
        }
        LOG.debug("read: " + entity.getName());
        return entity;
    }

    public static void parseMatrix(Model model, Element element) throws MolgenisModelException {
        String[] keywords = new String[]{"name", "content_entity", "content", "container", "row", "col", "row_entity", "col_entity"};
        ArrayList<String> key_words = new ArrayList<String>(Arrays.asList(keywords));
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            if (key_words.contains(element.getAttributes().item(i).getNodeName())) continue;
            throw new MolgenisModelException("attribute '" + element.getAttributes().item(i).getNodeName() + "' unknown for <entity>");
        }
        if (element.getAttribute("name") != null && element.getAttribute("name").isEmpty()) {
            String message = "name is missing for entity " + element.toString();
            LOG.error(message);
            throw new MolgenisModelException(message);
        }
        Matrix matrix = new Matrix(element.getAttribute("name"), model.getDatabase());
        matrix.setCol(element.getAttribute("col"));
        matrix.setRow(element.getAttribute("row"));
        matrix.setContentEntity(element.getAttribute("content_entity"));
        matrix.setContainer(element.getAttribute("container"));
        matrix.setColEntityName(element.getAttribute("col_entity"));
        matrix.setRowEntityName(element.getAttribute("row_entity"));
        matrix.setContent(element.getAttribute("content"));
        LOG.debug("read: " + matrix.toString());
    }

    public static void parseField(Entity entity, Element element) throws MolgenisModelException {
        String[] entity_field;
        String[] keywords = new String[]{"type", "name", "label", "auto", "nillable", "optional", "readonly", "default", "description", "desc", "unique", "hidden", "length", "enum_options", "default_code", "xref", "xref_entity", "xref_field", "xref_label", "xref_name", "mref_name", "mref_localid", "mref_remoteid", "filter", "filtertype", "filterfield", "filtervalue", "xref_cascade", "allocationSize", "jpaCascade", "aggregateable", "minRange", "maxRange"};
        ArrayList<String> key_words = new ArrayList<String>(Arrays.asList(keywords));
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            if (key_words.contains(element.getAttributes().item(i).getNodeName())) continue;
            throw new MolgenisModelException("attribute '" + element.getAttributes().item(i).getNodeName() + "' not allowed for <field>");
        }
        String type = element.getAttribute("type");
        String name = element.getAttribute("name");
        String label = element.getAttribute("label");
        String auto = element.getAttribute("auto");
        String nillable = element.getAttribute("nillable");
        String aggregateable = element.getAttribute("aggregateable");
        if (element.hasAttribute("optional")) {
            nillable = element.getAttribute("optional");
        }
        String readonly = element.getAttribute("readonly");
        String default_value = element.getAttribute("default");
        String description = element.getAttribute("description");
        if (description.isEmpty()) {
            description = element.getAttribute("desc");
        }
        String unique = element.getAttribute("unique");
        String hidden = element.getAttribute("hidden");
        String length = element.getAttribute("length");
        String enum_options = element.getAttribute("enum_options").replace('[', ' ').replace(']', ' ').trim();
        String default_code = element.getAttribute("default_code");
        String minRange = element.getAttribute("minRange");
        String maxRange = element.getAttribute("maxRange");
        String xref_entity = element.getAttribute("xref_entity");
        String xref_field = element.getAttribute("xref_field");
        String xref_label = element.getAttribute("xref_label");
        String mref_name = element.getAttribute("mref_name");
        String mref_localid = element.getAttribute("mref_localid");
        String mref_remoteid = element.getAttribute("mref_remoteid");
        if (type.isEmpty()) {
            type = "string";
        }
        if (element.hasAttribute("xref") && !element.hasAttribute("xref_field")) {
            xref_field = element.getAttribute("xref");
        }
        if (!xref_field.isEmpty() && !element.hasAttribute("xref_entity") && (entity_field = xref_field.split("[.]")).length == 2) {
            xref_entity = entity_field[0];
            xref_field = entity_field[1];
        }
        String filter = element.getAttribute("filter");
        String filtertype = element.getAttribute("filtertype");
        String filterfield = element.getAttribute("filterfield");
        String filtervalue = element.getAttribute("filtervalue");
        if (type.equals("varchar")) {
            type = "string";
        }
        if (type.equals("number")) {
            type = "int";
        }
        if (type.equals("boolean")) {
            type = "bool";
        }
        if (type.equals("xref_single")) {
            type = "xref";
        }
        if (type.equals("xref_multiple")) {
            type = "mref";
        }
        if (label.isEmpty()) {
            label = name;
        }
        if (xref_label == null || xref_label.isEmpty()) {
            xref_label = null;
        }
        if (type.equals("autoid")) {
            type = "string";
            nillable = "false";
            auto = "true";
            readonly = "true";
            unique = "true";
            aggregateable = "false";
            default_value = "";
        }
        if (type != null && type.isEmpty()) {
            throw new MolgenisModelException("type is missing for field '" + name + "' of entity '" + entity.getName() + "'");
        }
        if (MolgenisFieldTypes.getType(type) == null) {
            throw new MolgenisModelException("type '" + type + "' unknown for field '" + name + "' of entity '" + entity.getName() + "'");
        }
        if (name.isEmpty()) {
            throw new MolgenisModelException("name is missing for a field in entity '" + entity.getName() + "'");
        }
        if (hidden.equals("true") && !nillable.equals("true") && default_value.isEmpty() && !auto.equals("true")) {
            throw new MolgenisModelException("field '" + name + "' of entity '" + entity.getName() + "' must have a default value. A field that is not nillable and hidden must have a default value.");
        }
        String jpaCascade = null;
        if ((type.equals("mref") || type.equals("xref") || type.equals("categorical")) && element.hasAttribute("jpaCascade")) {
            jpaCascade = element.getAttribute("jpaCascade");
        }
        Field field = new Field(entity, MolgenisFieldTypes.getType(type), name, label, Boolean.parseBoolean(auto), Boolean.parseBoolean(nillable), Boolean.parseBoolean(readonly), default_value, jpaCascade);
        LOG.debug("read: " + field.toString());
        if (aggregateable.isEmpty()) {
            MolgenisFieldTypes.FieldTypeEnum fieldType = field.getType().getEnumType();
            field.setAggregateable(fieldType == MolgenisFieldTypes.FieldTypeEnum.BOOL || fieldType == MolgenisFieldTypes.FieldTypeEnum.XREF || fieldType == MolgenisFieldTypes.FieldTypeEnum.CATEGORICAL);
        } else if (aggregateable.equalsIgnoreCase("true")) {
            field.setAggregateable(true);
        }
        if (!description.isEmpty()) {
            field.setDescription(description.trim());
        }
        if (hidden.equals("true")) {
            field.setHidden(true);
        }
        if (!default_code.isEmpty()) {
            field.setDefaultCode(default_code);
        }
        if (filter.equals("true")) {
            LOG.warn("filter set for field '" + name + "' of entity '" + entity.getName() + "'");
            LOG.warn(filterfield + " " + filtertype + " " + filtervalue);
            LOG.warn(System.currentTimeMillis() + " - filter bool: '" + Boolean.parseBoolean(filter) + "'");
            if (filtertype != null && filtertype.isEmpty() || filterfield != null && filterfield.isEmpty()) {
                throw new MolgenisModelException("field '" + name + "' of entity '" + entity.getName() + "': when the filter is set to true, the filtertype, filterfield and filtervalue must be set");
            }
            if (filtervalue != null && filtervalue.isEmpty()) {
                LOG.warn("no value specified for filter in field '" + name + "' of entity '" + entity.getName() + "'");
            }
            field.setFilter(Boolean.parseBoolean(filter));
            field.setFiltertype(filtertype);
            field.setFilterfield(filterfield);
            field.setFiltervalue(filtervalue);
        }
        if (type.equals("string")) {
            if (!length.isEmpty()) {
                field.setVarCharLength(Integer.parseInt(length));
            } else {
                field.setVarCharLength(255);
            }
        } else if (type.equals("enum")) {
            Vector<String> options = new Vector<String>();
            StringTokenizer tokenizer = new StringTokenizer(enum_options, ",");
            while (tokenizer.hasMoreElements()) {
                options.add(tokenizer.nextToken().trim());
            }
            if (options.size() < 1) {
                throw new MolgenisModelException("enum_options must be ',' delimited for field '" + field.getName() + "' of entity '" + entity.getName() + "'");
            }
            field.setEnumOptions(options);
        } else if (type.equals("int") || type.equals("long")) {
            if (StringUtils.isNotBlank((CharSequence)minRange) && StringUtils.isNotBlank((CharSequence)maxRange)) {
                try {
                    field.setMinRange(Long.valueOf(minRange));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Illegal minRange value [" + minRange + "]");
                }
                try {
                    field.setMaxRange(Long.valueOf(maxRange));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Illegal maxRange value [" + maxRange + "]");
                }
            }
        } else if (type.equals("xref") || type.equals("mref") || type.equals("categorical")) {
            if (mref_name.isEmpty() && xref_entity.isEmpty()) {
                throw new MolgenisModelException("xref_entity must be set for xref field '" + field.getName() + "' of entity '" + entity.getName() + "'");
            }
            List<String> xref_labels = null;
            if (xref_label != null) {
                xref_labels = Arrays.asList(xref_label.split(","));
            }
            field.setXRefVariables(xref_entity, xref_field, xref_labels);
            if (type.equals("mref")) {
                if (!mref_name.isEmpty()) {
                    field.setMrefName(mref_name);
                }
                if (!mref_localid.isEmpty()) {
                    field.setMrefLocalid(mref_localid);
                }
                if (!mref_remoteid.isEmpty()) {
                    field.setMrefRemoteid(mref_remoteid);
                }
            }
            if (!element.getAttribute("xref_cascade").isEmpty()) {
                if (element.getAttribute("xref_cascade").equalsIgnoreCase("true")) {
                    field.setXrefCascade(true);
                } else {
                    throw new MolgenisModelException("Unknown option on xref_cascade: '" + element.getAttribute("xref_cascade") + "'");
                }
            }
        }
        try {
            entity.addField(field);
        }
        catch (Exception e) {
            throw new MolgenisModelException("duplicate field '" + field.getName() + "' in entity '" + entity.getName() + "'");
        }
        if (unique.equals("true")) {
            entity.addKey(field.getName(), null);
        }
        if (element.getChildNodes().getLength() >= 1) {
            String annotations = StringUtils.deleteWhitespace((String)element.getChildNodes().item(1).getTextContent()).trim();
            field.setAnnotations(annotations);
        }
    }

    public static void parseView(Model model, Element element) throws MolgenisModelException {
        ArrayList<String> entityList;
        String name = element.getAttribute("name");
        String label = element.getAttribute("label");
        String entities = element.getAttribute("entities");
        if (name.isEmpty()) {
            throw new MolgenisModelException("name is missing for view " + element.toString());
        }
        if (entities.isEmpty()) {
            throw new MolgenisModelException("entities is missing for view " + element.toString());
        }
        if (label.isEmpty()) {
            label = name;
        }
        if ((entityList = new ArrayList<String>(Arrays.asList(entities.split(",")))).size() < 2) {
            throw new MolgenisModelException("a view needs at least 2 entities, define as entities=\"e1,e2\": " + element.toString());
        }
        View view = new View(name, label, model.getDatabase());
        for (String viewentity : entityList) {
            if (view.getEntities().contains(viewentity)) {
                throw new MolgenisModelException("view " + name + " has duplicate viewentity entries (" + viewentity + ")");
            }
            view.addEntity(viewentity);
        }
    }

    public static void parseMethod(Model model, Element element) throws MolgenisModelException {
        if (element.getAttribute("name") != null && element.getAttribute("name").isEmpty()) {
            String message = "name is missing for method " + element.toString();
            LOG.error(message);
            throw new MolgenisModelException(message);
        }
        Method method = new Method(element.getAttribute("name"), model.getMethodSchema());
        NodeList nodes = element.getChildNodes();
        for (int nodeid = 0; nodeid < nodes.getLength(); ++nodeid) {
            Node node = nodes.item(nodeid);
            if (node.getNodeType() != 1) continue;
            if (((Element)node).getTagName().equals("description")) {
                method.setDescription(((Element)node).getTextContent().trim());
                continue;
            }
            if (((Element)node).getTagName().equals("parameter")) {
                MolgenisModelParser.parseParameter(method, (Element)node);
                continue;
            }
            if (((Element)node).getTagName().equals("return")) {
                MolgenisModelParser.parseReturnType(model, method, (Element)node);
                continue;
            }
            if (!((Element)node).getTagName().equals("query")) continue;
            MolgenisModelParser.parseQuery(model, method, (Element)node);
        }
    }

    public static void parseParameter(Method method, Element element) throws MolgenisModelException {
        if (element.getAttribute("name") != null && element.getAttribute("name").isEmpty()) {
            String message = "name is missing for parameter " + element.toString();
            LOG.error(message);
            throw new MolgenisModelException(message);
        }
        if (element.getAttribute("type") != null && element.getAttribute("type").isEmpty()) {
            String message = "type is missing for parameter " + element.toString();
            LOG.error(message);
            throw new MolgenisModelException(message);
        }
        Parameter parameter = new Parameter(method, Parameter.Type.getType(element.getAttribute("type")), element.getAttribute("name"), element.getAttribute("label"), false, element.getAttribute("default"));
        try {
            method.addParameter(parameter);
        }
        catch (Exception e) {
            throw new MolgenisModelException("duplicate parameter '" + parameter.getName() + "' in method '" + method.getName() + "'");
        }
    }

    public static void parseReturnType(Model model, Method method, Element element) throws MolgenisModelException {
        if (element.getAttribute("type") != null && element.getAttribute("type").isEmpty()) {
            String message = "type is missing for returntype " + element.toString();
            LOG.error(message);
            throw new MolgenisModelException(message);
        }
        Entity entity = model.getEntity(element.getAttribute("type"));
        try {
            method.setReturnType(entity);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void parseQuery(Model model, Method method, Element element) throws MolgenisModelException {
        if (element.getAttribute("entity") != null && element.getAttribute("entity").isEmpty()) {
            String message = "type is missing for returntype " + element.toString();
            LOG.error(message);
            throw new MolgenisModelException(message);
        }
        MethodQuery query = new MethodQuery(element.getAttribute("entity"));
        method.setQuery(query);
        NodeList nodes = element.getChildNodes();
        for (int nodeid = 0; nodeid < nodes.getLength(); ++nodeid) {
            Node node = nodes.item(nodeid);
            if (node.getNodeType() != 1 || !((Element)node).getTagName().equals("rule")) continue;
            MolgenisModelParser.parseQueryRule(model, query, (Element)node);
        }
    }

    public static void parseQueryRule(Model model, MethodQuery query, Element element) throws MolgenisModelException {
        if (element.getAttribute("field") != null && element.getAttribute("field").isEmpty()) {
            String message = "type is missing for field " + element.toString();
            LOG.error(message);
            throw new MolgenisModelException(message);
        }
        if (element.getAttribute("operator") != null && element.getAttribute("operator").isEmpty()) {
            String message = "type is missing for operator " + element.toString();
            LOG.error(message);
            throw new MolgenisModelException(message);
        }
        if (element.getAttribute("parameter") != null && element.getAttribute("parameter").isEmpty()) {
            String message = "type is missing for parameter " + element.toString();
            LOG.error(message);
            throw new MolgenisModelException(message);
        }
        query.addRule(new MethodQuery.Rule(element.getAttribute("field"), element.getAttribute("operator"), element.getAttribute("parameter")));
    }

    public static Model parseDbSchema(String xml) throws MolgenisModelException {
        Model model = new Model("molgenis");
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            Document document = builder.parse(is);
            MolgenisModelParser.parseXmlDocument(model, document);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MolgenisModelException(e.getMessage());
        }
        return model;
    }

    public static Model parseDbSchema(ArrayList<String> filenames) throws MolgenisModelException {
        return MolgenisModelParser.parseDbSchema(filenames, "molgenis");
    }

    public static Model parseDbSchema(ArrayList<String> filenames, String modelName) throws MolgenisModelException {
        Model model = new Model(modelName);
        for (String filename : filenames) {
            MolgenisModelParser.parseXmlDocument(model, MolgenisModelParser.parseXmlFile(filename));
        }
        return model;
    }

    private static Document parseXmlDocument(Model model, Document document) throws MolgenisModelException {
        Element document_root = document.getDocumentElement();
        if (document_root.getAttribute("name") != null && document_root.getAttribute("name").isEmpty()) {
            document_root.setAttribute("name", "molgenis");
        }
        String modelName = document_root.getAttribute("name");
        String modelLabel = document_root.getAttribute("label");
        model.setName(modelName);
        if (!"".equals(modelLabel)) {
            model.setLabel(modelLabel);
        }
        NodeList children = document_root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            if (element.getTagName().equals("module")) {
                MolgenisModelParser.parseModule(model, element);
                continue;
            }
            if (element.getTagName().equals("entity")) {
                MolgenisModelParser.parseEntity(model, element);
                continue;
            }
            if (element.getTagName().equals("matrix")) {
                MolgenisModelParser.parseMatrix(model, element);
                continue;
            }
            if (element.getTagName().equals("view")) {
                MolgenisModelParser.parseView(model, element);
                continue;
            }
            if (element.getTagName().equals("method")) {
                MolgenisModelParser.parseMethod(model, element);
                continue;
            }
            if (!element.getTagName().equals("description")) continue;
            model.setDBDescription(model.getDBDescription() + MolgenisModelParser.elementValueToString(element));
        }
        return document;
    }

    public static void parseModule(Model model, Element element) throws MolgenisModelException {
        int j;
        String[] keywords = new String[]{"name", "label"};
        ArrayList<String> key_words = new ArrayList<String>(Arrays.asList(keywords));
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            if (key_words.contains(element.getAttributes().item(i).getNodeName())) continue;
            throw new MolgenisModelException("attribute '" + element.getAttributes().item(i).getNodeName() + "' unknown for <module " + element.getAttribute("name") + ">");
        }
        if (element.getAttribute("name").trim().isEmpty()) {
            String message = "name is missing for module " + element.toString();
            LOG.error(message);
            throw new MolgenisModelException(message);
        }
        Module module = new Module(model.getName() + "." + element.getAttribute("name").trim(), model);
        if (element.getAttribute("label") != null && !element.getAttribute("label").isEmpty()) {
            module.setLabel(element.getAttribute("label"));
        }
        NodeList elements = element.getElementsByTagName("description");
        for (j = 0; j < elements.getLength(); ++j) {
            if (!elements.item(j).getParentNode().equals(element)) continue;
            module.setDescription(MolgenisModelParser.elementValueToString((Element)elements.item(j)));
        }
        elements = element.getElementsByTagName("entity");
        for (j = 0; j < elements.getLength(); ++j) {
            Element elem = (Element)elements.item(j);
            Entity e = MolgenisModelParser.parseEntity(model, elem);
            e.setNamespace(module.getName());
            module.getEntities().add(e);
            e.setModule(module);
        }
    }

    private static Document parseXmlFile(String filename) throws MolgenisModelException {
        Document document = null;
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(filename);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            try {
                document = builder.parse(Thread.currentThread().getContextClassLoader().getResourceAsStream(filename.trim()));
            }
            catch (Exception e2) {
                LOG.error("parsing of file '" + filename + "' failed.");
                e.printStackTrace();
                throw new MolgenisModelException("Parsing of DSL (ui) failed: " + e.getMessage());
            }
        }
        return document;
    }

    private static String elementValueToString(Element element) throws MolgenisModelException {
        StringWriter buffer = new StringWriter();
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "true");
            transformer.transform(new DOMSource(element), new StreamResult(buffer));
        }
        catch (TransformerException e) {
            throw new MolgenisModelException(e.getMessage());
        }
        String xml = buffer.toString();
        xml = xml.replace("<" + element.getTagName() + ">", "");
        xml = xml.replace("</" + element.getTagName() + ">", "");
        xml = xml.replace("<" + element.getTagName() + "/>", "");
        return xml;
    }
}

