/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class FileStore {
    private final String storageDir;

    public FileStore(String storageDir) {
        if (storageDir == null) {
            throw new IllegalArgumentException("storage dir is null");
        }
        this.storageDir = storageDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File store(InputStream is, String fileName) throws IOException {
        File file = new File(this.storageDir + '/' + fileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)is, (OutputStream)fos);
        }
        return file;
    }

    public File getFile(String fileName) {
        return new File(this.storageDir + '/' + fileName);
    }

    public boolean delete(String fileName) {
        File file = new File(this.storageDir + '/' + fileName);
        return file.delete();
    }

    public String getStorageDir() {
        return this.storageDir;
    }
}

