/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.framework.ui;

import javax.annotation.PostConstruct;
import org.molgenis.framework.ui.MolgenisPlugin;
import org.molgenis.framework.ui.MolgenisPluginFactory;
import org.molgenis.framework.ui.MolgenisPluginRegistry;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class MolgenisPluginController {
    public static final String PLUGIN_URI_PREFIX = "/plugin/";
    @Autowired
    private MolgenisPluginRegistry molgenisPluginRegistry;
    private final String uri;
    private final MolgenisPluginFactory molgenisPluginFactory;

    public MolgenisPluginController(String uri) {
        this(uri, null);
    }

    public MolgenisPluginController(String uri, MolgenisPluginFactory molgenisPluginFactory) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        if (!uri.startsWith(PLUGIN_URI_PREFIX)) {
            throw new IllegalArgumentException("uri does not start with /plugin/");
        }
        this.uri = uri;
        this.molgenisPluginFactory = molgenisPluginFactory;
    }

    public String getUri() {
        return this.uri;
    }

    public String getId() {
        return this.uri.substring(PLUGIN_URI_PREFIX.length());
    }

    @PostConstruct
    private void registerPlugin() {
        this.molgenisPluginRegistry.registerPlugin(new MolgenisPlugin(this.getId(), this.getId(), "", ""));
        if (this.molgenisPluginFactory != null) {
            this.molgenisPluginRegistry.registerPluginFactory(this.molgenisPluginFactory);
        }
    }
}

