/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model.elements;

import java.util.Vector;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.MethodQuery;
import org.molgenis.model.elements.MethodSchema;
import org.molgenis.model.elements.Parameter;

public class Method
extends MethodSchema {
    private String description = "";
    private Entity returntype = null;
    private Vector<Parameter> parameters = new Vector();
    private MethodQuery query = null;
    private static final long serialVersionUID = 2296459638604325393L;

    public Method(String name, MethodSchema parent) {
        super(name, parent);
    }

    public void setReturnType(Entity returntype) throws Exception {
        this.returntype = returntype;
    }

    public Entity getReturnType() {
        return this.returntype;
    }

    public void addParameter(Parameter parameter) throws MolgenisModelException {
        if (this.parameters.contains(parameter)) {
            throw new MolgenisModelException("Parameter with name " + parameter.getName() + " already in method.");
        }
        this.parameters.add(parameter);
    }

    public Vector<Parameter> getParameters() {
        return this.parameters;
    }

    public void setQuery(MethodQuery query) {
        this.query = query;
    }

    public MethodQuery getQuery() {
        return this.query;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        StringBuilder strBuilder = new StringBuilder();
        if (this.description != null && !this.description.equals("")) {
            strBuilder.append(this.description).append('\n');
        }
        if (this.returntype != null) {
            strBuilder.append(this.returntype.getName()).append(' ');
        }
        strBuilder.append("Method(").append(this.getName()).append(")\n(\n");
        for (Parameter parameter : this.parameters) {
            strBuilder.append("  ").append(parameter.toString()).append('\n');
        }
        strBuilder.append(");");
        if (this.query != null) {
            strBuilder.append("\n-> ").append(this.query.getEntity()).append(":\n");
            for (MethodQuery.Rule rule : this.query.getRules()) {
                strBuilder.append("   ").append(rule.getField()).append(' ').append(rule.getOperator()).append(' ').append(rule.getParameter()).append('\n');
            }
        }
        return strBuilder.toString();
    }
}

