/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.Part;
import org.apache.commons.io.FileUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class FileUploadUtils {
    public static File saveToTempFile(Part part) throws IOException {
        String filename = FileUploadUtils.getOriginalFileName(part);
        if (filename == null) {
            return null;
        }
        File file = File.createTempFile("molgenis-", "." + StringUtils.getFilenameExtension((String)filename));
        FileCopyUtils.copy((InputStream)part.getInputStream(), (OutputStream)new FileOutputStream(file));
        return file;
    }

    public static File saveToTempFolder(Part part) throws IOException {
        String filename = FileUploadUtils.getOriginalFileName(part);
        if (filename == null) {
            return null;
        }
        File file = new File(FileUtils.getTempDirectory(), filename);
        FileCopyUtils.copy((InputStream)part.getInputStream(), (OutputStream)new FileOutputStream(file));
        return file;
    }

    public static String getOriginalFileName(Part part) {
        String contentDisposition = part.getHeader("content-disposition");
        if (contentDisposition != null) {
            for (String cd : contentDisposition.split(";")) {
                if (!cd.trim().startsWith("filename")) continue;
                String filename = cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
                return StringUtils.hasText((String)filename) ? filename : null;
            }
        }
        return null;
    }
}

