/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.generators.GeneratorHelper;
import org.molgenis.model.elements.Matrix;
import org.molgenis.model.elements.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ForEachMatrixGenerator
extends Generator {
    private static final Logger LOG = LoggerFactory.getLogger(ForEachMatrixGenerator.class);

    public ForEachMatrixGenerator() {
        this(false);
    }

    public ForEachMatrixGenerator(boolean includeAbstract) {
    }

    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            Template template = this.createTemplate(this.getClass().getSimpleName() + this.getExtension() + ".ftl");
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            String packageName = this.getClass().getPackage().toString().substring(Generator.class.getPackage().toString().length());
            File targetDir = new File(this.getSourcePath(options) + model.getName().replace(".", "/") + packageName.replace(".", "/"));
            for (Matrix matrix : model.getMatrices()) {
                boolean created = targetDir.mkdirs();
                if (!created && !targetDir.exists()) {
                    throw new IOException("could not create " + targetDir);
                }
                File targetFile = new File(targetDir + "/" + GeneratorHelper.firstToUpper(matrix.getName()) + this.getType() + this.getExtension());
                templateArgs.put("matrix", matrix);
                templateArgs.put("model", model);
                templateArgs.put("template", template.getName());
                templateArgs.put("file", targetFile.toString());
                templateArgs.put("package", model.getName().toLowerCase() + packageName);
                FileOutputStream targetOut = new FileOutputStream(targetFile);
                template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
                ((OutputStream)targetOut).close();
                LOG.info("generated " + targetFile);
            }
        }
    }

    public String getType() {
        String className = this.getClass().getSimpleName();
        return className.substring(0, className.length() - 3);
    }
}

