/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.generators.db;

import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.molgenis.MolgenisOptions;
import org.molgenis.generators.Generator;
import org.molgenis.model.elements.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConfigGen
extends Generator {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseConfigGen.class);

    @Override
    public String getDescription() {
        return "Generates database configuration that can be used by a Spring container.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Model model, MolgenisOptions options) throws Exception {
        if (!options.generate_tests) {
            File target = new File(this.getSourcePath(options) + "org/molgenis".replace('.', '/') + "/DatabaseConfig.java");
            boolean created = target.getParentFile().mkdirs();
            if (!created && !target.getParentFile().exists()) {
                throw new IOException("could not create " + target.getParentFile());
            }
            Map<String, Object> templateArgs = this.createTemplateArguments(options);
            templateArgs.put("package", "org/molgenis".replace('/', '.'));
            Template template = this.createTemplate("/" + this.getClass().getSimpleName() + ".java.ftl");
            try (FileOutputStream targetOut = new FileOutputStream(target);){
                template.process(templateArgs, (Writer)new OutputStreamWriter((OutputStream)targetOut, Charset.forName("UTF-8")));
            }
            LOG.info("generated " + target);
        }
    }
}

