/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.model.elements;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.fieldtypes.EnumField;
import org.molgenis.fieldtypes.FieldType;
import org.molgenis.fieldtypes.MrefField;
import org.molgenis.fieldtypes.StringField;
import org.molgenis.fieldtypes.XrefField;
import org.molgenis.generators.GeneratorHelper;
import org.molgenis.model.MolgenisModelException;
import org.molgenis.model.elements.DBSchema;
import org.molgenis.model.elements.Entity;
import org.molgenis.model.elements.Unique;
import org.molgenis.util.SimpleTree;

public class Field
implements Serializable {
    public static final String TYPE_FIELD = "__Type";
    private static final int LENGTH_NOT_SET = 0;
    private Entity entity;
    private FieldType type;
    private String name;
    private String label;
    private boolean auto;
    private boolean nillable;
    private boolean hidden;
    private boolean readonly;
    private boolean aggregateable;
    private String default_value = null;
    private String description;
    private String default_code;
    private Vector<String> enum_options;
    private int varchar_length;
    private String xref_entity;
    private String xref_field;
    private List<String> xref_labels;
    private boolean xref_cascade = false;
    private String jpaCascade = null;
    private String mref_name;
    private String mref_localid;
    private String mref_remoteid;
    private boolean filter;
    private String filtertype;
    private String filterfield;
    private String filtervalue;
    private boolean system;
    private Object user_data;
    private String annotations;
    private static final long serialVersionUID = -1879739243713730190L;
    private String tableName;
    private Long minRange;
    private Long maxRange;

    public Field(Entity parent, String name, FieldType type) {
        this(parent, type, name, name, false, false, false, null, null);
    }

    public Field(Entity parent, FieldType type, String name, String label, boolean auto, boolean nillable, boolean readonly, String default_value, String jpaCascade) {
        this.entity = parent;
        this.type = type;
        this.name = name;
        this.label = label;
        this.auto = auto;
        this.nillable = nillable;
        this.readonly = readonly;
        this.default_value = default_value;
        this.description = "";
        this.default_code = "";
        this.varchar_length = 0;
        this.xref_entity = "";
        this.xref_field = "";
        this.xref_labels = new ArrayList<String>();
        this.system = false;
        this.user_data = null;
        this.jpaCascade = jpaCascade;
    }

    public Field(String name) {
        this.name = name;
        this.type = new StringField();
    }

    public Field(Entity parent, FieldType type, String name, String label, boolean auto, boolean nillable, boolean readonly, String default_value) {
        this(parent, type, name, label, auto, nillable, readonly, default_value, null);
    }

    public Field(Field field) {
        this.auto = field.auto;
        this.default_code = field.default_code;
        this.default_value = field.default_value;
        this.description = field.description;
        this.entity = field.entity;
        this.enum_options = field.enum_options;
        this.filter = field.filter;
        this.filterfield = field.filterfield;
        this.filtertype = field.filtertype;
        this.filtervalue = field.filtervalue;
        this.hidden = field.hidden;
        this.label = field.label;
        this.mref_name = field.mref_name;
        this.mref_localid = field.mref_localid;
        this.mref_remoteid = field.mref_remoteid;
        this.name = field.name;
        this.nillable = field.nillable;
        this.readonly = field.readonly;
        this.system = field.system;
        this.type = field.type;
        this.user_data = field.user_data;
        this.varchar_length = field.varchar_length;
        this.xref_field = field.xref_field;
        this.xref_labels = field.xref_labels;
        this.xref_entity = field.xref_entity;
    }

    @Deprecated
    public Entity getParent() {
        return this.entity;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public FieldType getType() {
        return this.type;
    }

    public void setType(FieldType type) {
        this.type = type;
    }

    public String getFormatString() {
        if (this.type instanceof XrefField || this.type instanceof MrefField) {
            try {
                return this.getXrefField().getFormatString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.type.getFormatString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getName();
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setAuto(boolean auto) {
        this.auto = auto;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public boolean isAggregateable() {
        return this.aggregateable;
    }

    public void setAggregateable(boolean aggregateable) {
        this.aggregateable = aggregateable;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean s) {
        this.system = s;
    }

    public boolean isLocal() {
        return this.type instanceof MrefField;
    }

    public boolean isCyclic() throws MolgenisModelException {
        if (!(this.type instanceof XrefField)) {
            return false;
        }
        if (this.xref_entity.equals(this.name)) {
            return true;
        }
        DBSchema root = (DBSchema)this.entity.getRoot();
        Entity e = (Entity)root.get(this.xref_entity);
        for (Field field : e.getAllFields()) {
            if (!(field.type instanceof XrefField) || !field.xref_entity.equals(this.name)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnum() {
        return this.type instanceof EnumField;
    }

    public boolean isXRef() {
        return this.type instanceof XrefField || this.type instanceof MrefField;
    }

    public boolean isMRef() {
        return this.type instanceof MrefField;
    }

    public String getDefaultValue() {
        return this.default_value;
    }

    public void setDefaultValue(String value) {
        this.default_value = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setEnumOptions(Vector<String> options) {
        this.enum_options = options;
    }

    public Vector<String> getEnumOptions() throws MolgenisModelException {
        if (!(this.type instanceof EnumField)) {
            throw new MolgenisModelException("Field is not a ENUM, so options cannot be set.");
        }
        return this.enum_options;
    }

    public void setVarCharLength(int length) {
        this.varchar_length = length;
    }

    public int getVarCharLength() throws MolgenisModelException {
        if (!(this.type instanceof StringField)) {
            throw new MolgenisModelException("Field is not a VARCHAR, so length cannot be retrieved.");
        }
        return this.varchar_length;
    }

    public void setXRefEntity(String xref_entity) {
        this.xref_entity = xref_entity;
    }

    public void setXRefVariables(String entity, String field, List<String> labels) {
        this.xref_entity = entity;
        this.xref_field = field;
        this.xref_labels = labels;
    }

    public Entity getXrefEntity() throws MolgenisModelException {
        Entity e = this.getEntity().getModel().getEntity(this.getXrefEntityName());
        if (e == null) {
            throw new MolgenisModelException("Xref entity '" + this.getXrefEntityName() + "' for attribute '" + this.getName() + "' of entity '" + this.getEntity().getName() + "' not part of model.");
        }
        return e;
    }

    public String getXrefEntityName() throws MolgenisModelException {
        if (!(this.type instanceof XrefField) && !(this.type instanceof MrefField)) {
            throw new MolgenisModelException("Field '" + this.getEntity().getName() + "." + this.getName() + "' is not a XREF, so xref-table cannot be retrieved.");
        }
        return this.xref_entity;
    }

    public Field getXrefField() throws MolgenisModelException {
        if (!(this.type instanceof XrefField) && !(this.type instanceof MrefField)) {
            throw new MolgenisModelException("Field is not a XREF, so xref-field cannot be retrieved.");
        }
        Field result = this.getXrefEntity().getAllField(this.getXrefFieldName());
        if (result == null) {
            throw new MolgenisModelException("xref_field is not known for field " + this.getEntity().getName() + "." + this.getName());
        }
        return result;
    }

    public String getXrefFieldName() {
        return this.xref_field;
    }

    public List<String> getXrefLabelNames() throws MolgenisModelException {
        ArrayList<String> label_names = new ArrayList<String>();
        for (String label : this.getXrefLabelsTemp()) {
            label_names.add(label.replace(this.getXrefEntityName() + ".", ""));
        }
        return label_names;
    }

    public SimpleTree<SimpleTree<?>> getXrefLabelTree() throws MolgenisModelException {
        return this.getXrefLabelTree(true);
    }

    public SimpleTree<SimpleTree<?>> getXrefLabelTree(boolean useJavaNames) throws MolgenisModelException {
        ArrayList<String> labels = new ArrayList<String>();
        for (String label : this.getXrefLabelNames()) {
            labels.add(this.getName() + "_" + GeneratorHelper.getJavaName(label, useJavaNames));
        }
        SimpleTree<Object> root = new SimpleTree<Object>(this.getName(), null);
        root.setValue(this);
        this.getXrefLabelTree(labels, root, useJavaNames);
        return root;
    }

    protected void getXrefLabelTree(List<String> labels, SimpleTree<?> parent) throws MolgenisModelException {
        this.getXrefLabelTree(labels, parent, true);
    }

    protected void getXrefLabelTree(List<String> labels, SimpleTree<?> parent, boolean useJavaNames) throws MolgenisModelException {
        String name;
        for (Field f : this.getXrefEntity().getAllFields()) {
            name = parent.getName() + "_" + GeneratorHelper.getJavaName(f.getName(), useJavaNames);
            if (f.getType() instanceof XrefField || f.getType() instanceof MrefField || !labels.contains(name)) continue;
            SimpleTree leaf = new SimpleTree(name, parent);
            leaf.setValue(f);
        }
        block1: for (Field f : this.getXrefEntity().getAllFields()) {
            name = parent.getName() + "_" + f.getName();
            if (!(f.getType() instanceof XrefField) || f.getXrefEntity().equals(this.getXrefEntity())) continue;
            SimpleTree<Object> node = new SimpleTree<Object>(name, null);
            f.getXrefLabelTree(labels, node);
            for (SimpleTree simpleTree : node.getAllChildren()) {
                if (!labels.contains(simpleTree.getName())) continue;
                node.setParent(parent);
                node.setValue(f);
                continue block1;
            }
        }
    }

    public List<Field> getXrefLabelPath(String label) throws MolgenisModelException {
        return this.allPossibleXrefLabels().get(label);
    }

    public List<Field> getXrefLabels() throws MolgenisModelException {
        ArrayList<Field> result = new ArrayList<Field>();
        for (String label : this.getXrefLabelNames()) {
            if (label.contains(".")) {
                result.add(this.getEntity().getModel().findField(label));
                continue;
            }
            if (label.contains("_")) {
                Map<String, List<Field>> candidates = this.allPossibleXrefLabels();
                for (Map.Entry<String, List<Field>> entry : candidates.entrySet()) {
                    String key = entry.getKey();
                    if (!key.toLowerCase().equals(label.toLowerCase())) continue;
                    List<Field> value = entry.getValue();
                    result.add(value.get(value.size() - 1));
                }
                continue;
            }
            Field target = this.getEntity().getModel().findField(this.getXrefEntity().getName() + "." + label);
            result.add(new Field(target));
        }
        return result;
    }

    public List<String> getXrefLabelsTemp() throws MolgenisModelException {
        if (this.xref_labels == null || this.xref_labels.size() == 0) {
            if (this.getXrefEntity() == null) {
                throw new MolgenisModelException("Cannot find xref_entity='" + this.getXrefEntityName() + "' for " + this.getEntity().getName() + "." + this.getName());
            }
            if (this.getXrefEntity().getXrefLabels() != null) {
                return this.getXrefEntity().getXrefLabels();
            }
            return Arrays.asList(this.xref_field);
        }
        return this.xref_labels;
    }

    public String getMrefName() {
        return this.mref_name;
    }

    public void setMrefName(String linktable) {
        this.mref_name = linktable;
    }

    public String getMrefLocalid() {
        return this.mref_localid;
    }

    public void setMrefLocalid(String mref_localid) {
        this.mref_localid = mref_localid;
    }

    public String getMrefRemoteid() {
        return this.mref_remoteid;
    }

    public void setMrefRemoteid(String mref_remoteid) {
        this.mref_remoteid = mref_remoteid;
    }

    public void setUserData(Object obj) {
        this.user_data = obj;
    }

    public Object getUserData() {
        return this.user_data;
    }

    public String getDefaultCode() {
        return this.default_code;
    }

    public void setDefaultCode(String default_code) {
        this.default_code = default_code;
    }

    public String toString() {
        String str = "Field(";
        str = str + "entity=" + this.entity.getName();
        str = str + ", name=" + this.name;
        str = str + ", type=" + this.type;
        if (this.type instanceof StringField) {
            str = str + "[" + this.varchar_length + "]";
        } else if (this.type instanceof XrefField || this.type instanceof MrefField) {
            try {
                str = str + "[" + this.getXrefEntityName() + "." + this.getXrefFieldName() + "]";
            }
            catch (MolgenisModelException e) {
                e.printStackTrace();
            }
        }
        if (this.type instanceof MrefField) {
            str = str + ", mref_name=" + this.mref_name + ", mref_localid=" + this.mref_localid + ", mref_remoteid=" + this.mref_remoteid;
        }
        if (this.type instanceof XrefField || this.type instanceof MrefField) {
            str = str + ", xref_label=" + new GeneratorHelper(null).toCsv(this.xref_labels);
        }
        str = str + ", auto=" + this.auto;
        str = str + ", nillable=" + this.nillable;
        str = str + ", readonly=" + this.readonly;
        str = str + ", default=" + this.default_value;
        if (this.enum_options != null) {
            str = str + ", enum_options=" + this.enum_options;
        }
        str = str + ")";
        return str;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Field) {
            return this.name.equals(((Field)obj).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(String annotations) {
        this.annotations = annotations;
    }

    public boolean hasFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public String getFilterfield() {
        return this.filterfield;
    }

    public void setFilterfield(String filterfield) {
        this.filterfield = filterfield;
    }

    public String getFiltertype() {
        return this.filtertype;
    }

    public void setFiltertype(String filtertype) {
        this.filtertype = filtertype;
    }

    public String getFiltervalue() {
        return this.filtervalue;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public void setFiltervalue(String filtervalue) {
        this.filtervalue = filtervalue;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    public void setXrefField(String xrefField) {
        this.xref_field = xrefField;
    }

    public void setXrefLabelNames(List<String> labelNames) {
        this.xref_labels = labelNames;
    }

    public Long getMinRange() {
        return this.minRange;
    }

    public void setMinRange(Long minRange) {
        this.minRange = minRange;
    }

    public Long getMaxRange() {
        return this.maxRange;
    }

    public void setMaxRange(Long maxRange) {
        this.maxRange = maxRange;
    }

    public Map<String, List<Field>> allPossibleXrefLabels() throws MolgenisModelException {
        if (!(this.getType() instanceof XrefField) && !(this.getType() instanceof MrefField)) {
            throw new MolgenisModelException("asking xref labels for non-xref field");
        }
        LinkedHashMap<String, List<Field>> result = new LinkedHashMap<String, List<Field>>();
        for (Unique key : this.getXrefEntity().getAllKeys()) {
            for (Field f : key.getFields()) {
                if (f.getType() instanceof XrefField || f.getType() instanceof MrefField) {
                    f = this.getXrefEntity().getAllField(f.getName());
                    Map<String, List<Field>> subpaths = f.allPossibleXrefLabels();
                    for (Map.Entry<String, List<Field>> pair : subpaths.entrySet()) {
                        List<Field> path = pair.getValue();
                        path.add(0, f);
                        String label = f.getName() + "_" + pair.getKey();
                        result.put(label, path);
                        result.put(label, path);
                    }
                    continue;
                }
                ArrayList<Field> path = new ArrayList<Field>();
                path.add(f);
                result.put(f.getName(), path);
            }
        }
        return result;
    }

    public Integer getLength() throws MolgenisModelException {
        if (this.getType() instanceof StringField) {
            return this.getVarCharLength();
        }
        return null;
    }

    public synchronized boolean isXrefCascade() {
        return this.xref_cascade;
    }

    public synchronized void setXrefCascade(boolean xrefCascade) {
        this.xref_cascade = xrefCascade;
    }

    public String getJpaCascade() {
        return this.jpaCascade;
    }

    public void setJpaCascade(String jpaCascade) {
        this.jpaCascade = jpaCascade;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSqlName() {
        if (StringUtils.isNotEmpty((CharSequence)this.tableName)) {
            return StringUtils.capitalize((String)this.tableName) + "." + this.name;
        }
        return this.name;
    }

    public boolean isUnique() throws MolgenisModelException {
        for (Unique unique : this.entity.getUniqueKeysWithoutPk()) {
            if (unique.getFields().size() != 1 || !unique.getFields().get(0).getName().equals(this.name)) continue;
            return true;
        }
        return false;
    }
}

