/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.PrintStream;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;

public class ExceptionHandler {
    public static void handle(Throwable t, Logger l) {
        ExceptionHandler.printSimpleStackTrace(t, l);
        l.error("Detailed stack trace:");
        ExceptionUtils.printRootCauseStackTrace((Throwable)t);
    }

    public static void handle(Throwable t) {
        ExceptionHandler.handle(t, System.err);
    }

    public static void handle(Throwable t, PrintStream out) {
        ExceptionHandler.printSimpleStackTrace(t, out);
        out.println("Detailed stack trace:");
        ExceptionUtils.printRootCauseStackTrace((Throwable)t);
    }

    private static void printSimpleStackTrace(Throwable t, PrintStream o) {
        Throwable prevCause = null;
        StringBuilder tabsBuilder = new StringBuilder();
        for (Throwable cause = t.getCause(); cause != null && prevCause != cause; cause = cause.getCause()) {
            o.println(String.format("%sCause: %s", tabsBuilder.toString(), cause.getMessage()));
            tabsBuilder.append('\t');
            prevCause = cause;
        }
    }

    private static void printSimpleStackTrace(Throwable t, Logger l) {
        Throwable prevCause = null;
        StringBuilder tabsBuilder = new StringBuilder();
        for (Throwable cause = t.getCause(); cause != null && prevCause != cause; cause = cause.getCause()) {
            l.error(String.format("%sCause: %s", tabsBuilder.toString(), cause.getMessage()));
            tabsBuilder.append('\t');
            prevCause = cause;
        }
    }
}

