/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.molgenis.util.ResourceUtils;

public class ResourceFingerprintRegistry {
    private final Map<String, String> resourceFingerprints = new ConcurrentHashMap<String, String>();

    public String getFingerprint(String resourceName) throws IOException {
        return this.getFingerprint(this.getClass(), resourceName);
    }

    public String getFingerprint(Class<?> contextClass, String resourceName) throws IOException {
        String resourceFingerprint = this.resourceFingerprints.get(resourceName);
        if (resourceFingerprint == null) {
            resourceFingerprint = this.createFingerprint(contextClass, resourceName);
            this.resourceFingerprints.put(resourceName, resourceFingerprint);
        }
        return resourceFingerprint;
    }

    private String createFingerprint(Class<?> contextClass, String resourceName) throws IOException {
        byte[] bytes = contextClass != null ? ResourceUtils.getBytes(contextClass, resourceName) : ResourceUtils.getBytes(resourceName);
        HashCode crc32 = Hashing.crc32().hashBytes(bytes);
        return BaseEncoding.base64Url().omitPadding().encode(crc32.asBytes());
    }
}

