/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util.stream;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class MultimapCollectors {
    public static <K, V, E> Collector<E, ArrayListMultimap<K, V>, ArrayListMultimap<K, V>> toArrayListMultimap(Function<E, K> keyGenerator, Function<E, V> valueGenerator) {
        return MultimapCollectors.toMultimap(ArrayListMultimap::create, keyGenerator, valueGenerator);
    }

    public static <K, V, A extends Multimap<K, V>, E> Collector<E, A, A> toMultimap(Supplier<A> supplier, Function<E, K> keyGenerator, Function<E, V> valueGenerator) {
        return Collector.of(supplier, (map, entry) -> map.put(keyGenerator.apply(entry), valueGenerator.apply(entry)), (map1, map2) -> {
            map1.putAll(map2);
            return map1;
        }, new Collector.Characteristics[0]);
    }

    public static <K, V, A extends Multimap<K, V>> Collector<Map.Entry<K, V>, A, A> toMultimap(Supplier<A> supplier) {
        return MultimapCollectors.toMultimap(supplier, Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <K, V> Collector<Map.Entry<K, V>, LinkedHashMultimap<K, V>, LinkedHashMultimap<K, V>> toLinkedHashMultimap() {
        return MultimapCollectors.toMultimap(LinkedHashMultimap::create);
    }
}

