/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class HugeSet<E>
implements Set<E>,
Closeable {
    protected static final int THRESHOLD = 10000;
    private DB mapDB;
    private Set<E> set;
    private final HashSet<E> hashSet = new HashSet();

    @Override
    public int size() {
        if (this.set == null) {
            return this.hashSet.size();
        }
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        if (this.set == null) {
            return this.hashSet.isEmpty();
        }
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (this.set == null) {
            return this.hashSet.contains(o);
        }
        return this.set.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        if (this.set == null) {
            return this.hashSet.iterator();
        }
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        if (this.set == null) {
            return this.hashSet.toArray();
        }
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (this.set == null) {
            return this.hashSet.toArray(a);
        }
        return this.set.toArray(a);
    }

    @Override
    public boolean add(E obj) {
        if (this.hashSet.size() == 10000) {
            File dbFile;
            try {
                dbFile = File.createTempFile("mapdb", "temp");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.mapDB = DBMaker.newFileDB((File)dbFile).deleteFilesAfterClose().transactionDisable().make();
            this.set = this.mapDB.createHashSet("set").make();
            this.set.addAll(this.hashSet);
            this.hashSet.clear();
        }
        if (this.set == null) {
            return this.hashSet.add(obj);
        }
        return this.set.add(obj);
    }

    @Override
    public boolean remove(Object o) {
        if (this.set == null) {
            return this.hashSet.remove(o);
        }
        return this.set.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.set == null) {
            return this.hashSet.containsAll(c);
        }
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        c.forEach(this::add);
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.set == null) {
            return this.hashSet.retainAll(c);
        }
        return this.set.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.set == null) {
            return this.hashSet.removeAll(c);
        }
        return this.set.removeAll(c);
    }

    @Override
    public void clear() {
        if (this.set == null) {
            this.hashSet.clear();
        } else {
            this.set.clear();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mapDB != null) {
            this.mapDB.close();
        }
    }
}

