/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ErrorMessageResponse {
    private List<ErrorMessage> errors;

    public ErrorMessageResponse() {
    }

    public ErrorMessageResponse(ErrorMessage errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException("error message is null");
        }
        this.addErrorMessage(errorMessage);
    }

    public ErrorMessageResponse(List<ErrorMessage> errorMessages) {
        if (errorMessages == null) {
            throw new IllegalArgumentException("error messages is null");
        }
        this.addErrorMessages(errorMessages);
    }

    public List<ErrorMessage> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public void addErrorMessage(ErrorMessage errorMessage) {
        if (this.errors == null) {
            this.errors = new ArrayList<ErrorMessage>();
        }
        this.errors.add(errorMessage);
    }

    public void addErrorMessages(List<ErrorMessage> errorMessages) {
        if (this.errors == null) {
            this.errors = new ArrayList<ErrorMessage>();
        }
        this.errors.addAll(errorMessages);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.errors == null ? 0 : this.errors.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorMessageResponse other = (ErrorMessageResponse)obj;
        return !(this.errors == null ? other.errors != null : !this.errors.equals(other.errors));
    }

    public static class ErrorMessage {
        private static final String DEFAULT_ERROR_MESSAGE = "Unknown error";
        private final String message;
        private final Integer code;

        public ErrorMessage(String message) {
            this(message, null);
        }

        public ErrorMessage(String message, Integer code) {
            this.message = message != null ? message : DEFAULT_ERROR_MESSAGE;
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public Integer getCode() {
            return this.code;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ErrorMessage other = (ErrorMessage)obj;
            if (this.code == null ? other.code != null : !this.code.equals(other.code)) {
                return false;
            }
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }
    }
}

