/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.molgenis.util.MolgenisDateFormat;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class GsonFactoryBean
implements FactoryBean<Gson>,
InitializingBean {
    private boolean serializeNulls = false;
    private boolean prettyPrinting = false;
    private boolean disableHtmlEscaping = false;
    private String dateFormatPattern = MolgenisDateFormat.getDateTimeFormat().toPattern();
    private List<TypeAdapterFactory> typeAdapterFactoryList;
    private Map<Class<?>, Object> typeAdapterHierarchyFactoryMap;
    private Gson gson;

    public void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public void setPrettyPrinting(boolean prettyPrinting) {
        this.prettyPrinting = prettyPrinting;
    }

    public void setDisableHtmlEscaping(boolean disableHtmlEscaping) {
        this.disableHtmlEscaping = disableHtmlEscaping;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public void registerTypeAdapterFactory(TypeAdapterFactory typeAdapterFactory) {
        if (this.typeAdapterFactoryList == null) {
            this.typeAdapterFactoryList = new ArrayList<TypeAdapterFactory>();
        }
        this.typeAdapterFactoryList.add(typeAdapterFactory);
    }

    public void registerTypeHierarchyAdapter(Class<?> clazz, Object typeAdapter) {
        if (this.typeAdapterHierarchyFactoryMap == null) {
            this.typeAdapterHierarchyFactoryMap = Maps.newHashMap();
        }
        this.typeAdapterHierarchyFactoryMap.put(clazz, typeAdapter);
    }

    public void afterPropertiesSet() {
        GsonBuilder builder = new GsonBuilder();
        if (this.serializeNulls) {
            builder.serializeNulls();
        }
        if (this.prettyPrinting) {
            builder.setPrettyPrinting();
        }
        if (this.disableHtmlEscaping) {
            builder.disableHtmlEscaping();
        }
        if (this.dateFormatPattern != null) {
            builder.setDateFormat(this.dateFormatPattern);
        }
        if (this.typeAdapterFactoryList != null) {
            this.typeAdapterFactoryList.forEach(arg_0 -> ((GsonBuilder)builder).registerTypeAdapterFactory(arg_0));
        }
        if (this.typeAdapterHierarchyFactoryMap != null) {
            this.typeAdapterHierarchyFactoryMap.forEach((arg_0, arg_1) -> ((GsonBuilder)builder).registerTypeHierarchyAdapter(arg_0, arg_1));
        }
        this.gson = builder.create();
    }

    public Gson getObject() {
        return this.gson;
    }

    public Class<?> getObjectType() {
        return Gson.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

