/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.util;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.molgenis.util.BaseHttpMessageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class GsonHttpMessageConverter
extends BaseHttpMessageConverter<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(GsonHttpMessageConverter.class);
    private static final MediaType APPLICATION_JAVASCRIPT = new MediaType("application", "javascript", DEFAULT_CHARSET);
    private final Gson gson;
    private Type type = null;
    private boolean prefixJson = false;

    public GsonHttpMessageConverter(Gson gson) {
        super(MediaType.APPLICATION_JSON, APPLICATION_JAVASCRIPT);
        this.gson = Objects.requireNonNull(gson);
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setPrefixJson(boolean prefixJson) {
        this.prefixJson = prefixJson;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.canRead(mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return this.canWrite(mediaType);
    }

    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        InputStreamReader json = new InputStreamReader(inputMessage.getBody(), this.getCharset(inputMessage.getHeaders()));
        try {
            Type typeOfT = this.getType();
            if (LOG.isTraceEnabled()) {
                String jsonStr = IOUtils.toString((Reader)json);
                LOG.trace("Json request:\n" + jsonStr);
                if (typeOfT != null) {
                    Object object = this.gson.fromJson(jsonStr, typeOfT);
                    return object;
                }
                Object object = this.gson.fromJson(jsonStr, clazz);
                return object;
            }
            if (typeOfT != null) {
                Object object = this.gson.fromJson((Reader)json, typeOfT);
                return object;
            }
            Object object = this.gson.fromJson((Reader)json, clazz);
            return object;
        }
        catch (JsonParseException ex) {
            throw new HttpMessageNotReadableException("Could not read JSON: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((Reader)json);
        }
    }

    protected void writeInternal(Object o, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        OutputStreamWriter writer = new OutputStreamWriter(outputMessage.getBody(), this.getCharset(outputMessage.getHeaders()));
        String callback = this.getCallbackParam();
        if (callback != null) {
            writer.append(callback).append('(');
        }
        try {
            Type typeOfSrc = this.getType();
            if (LOG.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                if (this.prefixJson) {
                    sb.append("{} && ");
                }
                if (typeOfSrc != null) {
                    sb.append(this.gson.toJson(o, typeOfSrc));
                } else {
                    sb.append(this.gson.toJson(o));
                }
                LOG.debug("Json response:\n" + sb.toString());
                writer.write(sb.toString());
            } else {
                if (this.prefixJson) {
                    writer.append("{} && ");
                }
                if (typeOfSrc != null) {
                    this.gson.toJson(o, typeOfSrc, (Appendable)writer);
                } else {
                    this.gson.toJson(o, (Appendable)writer);
                }
            }
            if (callback != null) {
                writer.append(')');
            }
        }
        catch (JsonIOException ex) {
            throw new HttpMessageNotWritableException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    private String getCallbackParam() {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            return request.getParameter("callback");
        }
        catch (IllegalStateException ex) {
            return null;
        }
    }
}

