/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.core.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class SchemaLoader
implements LSResourceResolver {
    private Schema schema;

    public SchemaLoader(String schemaName) {
        try {
            Resource schemaResource = this.getSchema(schemaName);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(this);
            this.schema = schemaFactory.newSchema(new StreamSource(schemaResource.getInputStream()));
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException("Could not load schemas", e);
        }
    }

    public SchemaLoader(InputStream is) {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(this);
            this.schema = schemaFactory.newSchema(new StreamSource(is));
        }
        catch (SAXException e) {
            throw new RuntimeException("Could not load schemas", e);
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    private Resource getSchema(String schemaName) throws IOException {
        String searchPattern;
        PathMatchingResourcePatternResolver resourcePatternResolver;
        Resource[] resources;
        if (schemaName.contains("/")) {
            schemaName = schemaName.substring(schemaName.lastIndexOf(47));
        }
        if ((resources = (resourcePatternResolver = new PathMatchingResourcePatternResolver()).getResources(searchPattern = "classpath*:/**/" + schemaName)).length == 0) {
            throw new RuntimeException("Could not find schema [" + schemaName + "]");
        }
        return resources[0];
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        InputStream resourceAsStream;
        try {
            resourceAsStream = this.getSchema(systemId).getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new LSInputImpl(publicId, systemId, resourceAsStream);
    }

    protected static class LSInputImpl
    implements LSInput {
        private String publicId;
        private String systemId;
        private BufferedInputStream inputStream;

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public String getStringData() {
            BufferedInputStream bufferedInputStream = this.inputStream;
            synchronized (bufferedInputStream) {
                try {
                    return IOUtils.toString((InputStream)this.inputStream, (String)"UTF-8");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void setBaseURI(String baseURI) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setByteStream(InputStream byteStream) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEncoding(String encoding) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setStringData(String stringData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        public BufferedInputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(BufferedInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public LSInputImpl(String publicId, String sysId, InputStream input) {
            this.publicId = publicId;
            this.systemId = sysId;
            this.inputStream = new BufferedInputStream(input);
        }
    }
}

