/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.das.impl;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import org.molgenis.das.impl.DasURLFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.WebApplicationInitializer;
import uk.ac.ebi.mydas.controller.MydasServlet;

public class WebAppInitializer
implements WebApplicationInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(WebAppInitializer.class);

    public void onStartup(ServletContext servletContext) throws ServletException {
        FilterRegistration.Dynamic filter = servletContext.addFilter("dasFilter", (Filter)new DasURLFilter());
        if (filter == null) {
            LOG.warn("ServletContext already contains a complete FilterRegistration for servlet 'dasFilter'");
        } else {
            filter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/das/*"});
        }
        ServletRegistration.Dynamic dasServlet = servletContext.addServlet("dasServlet", (Servlet)new MydasServlet());
        if (dasServlet == null) {
            LOG.warn("ServletContext already contains a complete ServletRegistration for servlet 'dasServlet'");
        } else {
            dasServlet.setLoadOnStartup(1);
            dasServlet.addMapping(new String[]{"/das/*"});
        }
    }
}

