/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.das;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.das.impl.MolgenisDasTarget;
import uk.ac.ebi.mydas.datasource.RangeHandlingAnnotationDataSource;
import uk.ac.ebi.mydas.exceptions.BadReferenceObjectException;
import uk.ac.ebi.mydas.exceptions.CoordinateErrorException;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.exceptions.UnimplementedFeatureException;
import uk.ac.ebi.mydas.model.DasAnnotatedSegment;
import uk.ac.ebi.mydas.model.DasEntryPoint;
import uk.ac.ebi.mydas.model.DasFeature;
import uk.ac.ebi.mydas.model.DasFeatureOrientation;
import uk.ac.ebi.mydas.model.DasMethod;
import uk.ac.ebi.mydas.model.DasPhase;
import uk.ac.ebi.mydas.model.DasType;
import uk.ac.ebi.mydas.model.Range;

@SuppressWarnings(value={"DMI_COLLECTION_OF_URLS"}, justification="Third party class requires a map of URLs")
public abstract class RangeHandlingDataSource
implements RangeHandlingAnnotationDataSource {
    protected DasFeature createDasFeature(Integer start, Integer stop, String identifier, String name, String description, String link, DasType type, DasMethod method, String dataSet, String patient, List<String> notes) throws DataSourceException {
        if (stop == null) {
            stop = start;
        }
        String featureDescription = "";
        featureDescription = StringUtils.isNotEmpty((CharSequence)description) ? (StringUtils.isNotEmpty((CharSequence)name) ? name + "," + description : description) : identifier;
        notes.add("track:" + dataSet);
        notes.add("source:MOLGENIS");
        if (StringUtils.isNotEmpty((CharSequence)patient)) {
            notes.add("patient:" + patient);
        }
        HashMap<URL, String> linkout = new HashMap<URL, String>();
        try {
            linkout.put(new URL(link), "Link");
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        ArrayList<MolgenisDasTarget> dasTargets = new ArrayList<MolgenisDasTarget>();
        dasTargets.add(new MolgenisDasTarget(identifier, start, stop, featureDescription));
        ArrayList parents = new ArrayList();
        DasFeature feature = new DasFeature(identifier, featureDescription, type, method, start.intValue(), stop.intValue(), new Double(0.0), DasFeatureOrientation.ORIENTATION_NOT_APPLICABLE, DasPhase.PHASE_NOT_APPLICABLE, notes, linkout, dasTargets, parents, null);
        return feature;
    }

    public void destroy() {
    }

    public DasAnnotatedSegment getFeatures(String arg0, Integer arg1) throws BadReferenceObjectException, DataSourceException {
        throw new BadReferenceObjectException(arg0, "The handling of this request is not supported");
    }

    public Collection<DasAnnotatedSegment> getFeatures(Collection<String> arg0, Integer arg1, Range arg2) throws UnimplementedFeatureException, DataSourceException {
        throw new UnimplementedFeatureException("Not implemented");
    }

    public URL getLinkURL(String arg0, String arg1) throws UnimplementedFeatureException, DataSourceException {
        throw new UnimplementedFeatureException("Not implemented");
    }

    public int getTotalEntryPoints() throws UnimplementedFeatureException, DataSourceException {
        throw new UnimplementedFeatureException("Not implemented");
    }

    public DasAnnotatedSegment getFeatures(String arg0, int arg1, int arg2, Integer arg3, Range arg4) throws BadReferenceObjectException, CoordinateErrorException, DataSourceException, UnimplementedFeatureException {
        throw new UnimplementedFeatureException("Not implemented");
    }

    public DasAnnotatedSegment getFeatures(String arg0, Integer arg1, Range arg2) throws BadReferenceObjectException, DataSourceException, UnimplementedFeatureException {
        throw new UnimplementedFeatureException("Not implemented");
    }

    public Collection<DasAnnotatedSegment> getFeatures(Collection<String> arg0, Integer arg1) throws UnimplementedFeatureException, DataSourceException {
        throw new UnimplementedFeatureException("Not implemented");
    }

    public String getEntryPointVersion() throws UnimplementedFeatureException, DataSourceException {
        throw new UnimplementedFeatureException("Not implemented");
    }

    public Collection<DasEntryPoint> getEntryPoints(Integer segmentId, Integer notUsed) throws UnimplementedFeatureException, DataSourceException {
        throw new UnimplementedFeatureException("Not implemented");
    }
}

