/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.das.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.das.RangeHandlingDataSource;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.support.GenomicDataSettings;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.util.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.mydas.configuration.DataSourceConfiguration;
import uk.ac.ebi.mydas.configuration.PropertyType;
import uk.ac.ebi.mydas.datasource.RangeHandlingAnnotationDataSource;
import uk.ac.ebi.mydas.exceptions.BadReferenceObjectException;
import uk.ac.ebi.mydas.exceptions.DataSourceException;
import uk.ac.ebi.mydas.model.DasAnnotatedSegment;
import uk.ac.ebi.mydas.model.DasFeature;
import uk.ac.ebi.mydas.model.DasMethod;
import uk.ac.ebi.mydas.model.DasType;

public class RepositoryRangeHandlingDataSource
extends RangeHandlingDataSource
implements RangeHandlingAnnotationDataSource {
    private final DataService dataService = (DataService)ApplicationContextProvider.getApplicationContext().getBean(DataService.class);
    private final GenomicDataSettings config = (GenomicDataSettings)ApplicationContextProvider.getApplicationContext().getBean(GenomicDataSettings.class);
    private DasType mutationType;
    private DasMethod method;
    private String type;
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryRangeHandlingDataSource.class);

    public void init(ServletContext servletContext, Map<String, PropertyType> globalParameters, DataSourceConfiguration dataSourceConfig) throws DataSourceException {
        this.type = ((PropertyType)dataSourceConfig.getDataSourceProperties().get("type")).getValue();
        this.mutationType = new DasType(this.type, null, "?", this.type);
        this.method = new DasMethod("not_recorded", "not_recorded", "ECO:0000037");
    }

    public DasAnnotatedSegment getFeatures(String segmentParamString, int start, int stop, Integer maxbins) throws BadReferenceObjectException, DataSourceException {
        String[] segmentParts = segmentParamString.split(",");
        String dataSet = null;
        String segmentId = null;
        String posAttribute = null;
        String chromosomeAttribute = null;
        String stopAttribute = null;
        String refAttribute = null;
        String altAttribute = null;
        String descriptionAttribute = null;
        String linkAttribute = null;
        String patientAttribute = null;
        if (segmentParts.length > 1) {
            segmentId = segmentParts[0];
            String customParam = segmentParts[1];
            if (customParam.indexOf("dasdataset_") != -1) {
                dataSet = customParam.substring(11);
            }
        }
        if (maxbins == null || maxbins < 0) {
            maxbins = 1000;
        }
        Stream<Entity> entityIterable = this.queryDataSet(segmentId, start, stop, dataSet, maxbins);
        ArrayList<DasFeature> features = new ArrayList<DasFeature>();
        Integer score = 0;
        HashMap<String, DasType> patients = new HashMap<String, DasType>();
        Iterator it = entityIterable.iterator();
        while (it.hasNext()) {
            DasType type;
            ArrayList attributes;
            String valueAlt;
            String valueRef;
            String valuePatient;
            String valueLink;
            String valueDescription;
            Integer valueStop;
            Integer valueStart;
            Entity entity;
            block18: {
                block17: {
                    entity = (Entity)it.next();
                    valueStart = null;
                    valueStop = null;
                    valueDescription = null;
                    valueLink = null;
                    valuePatient = null;
                    valueRef = null;
                    valueAlt = null;
                    posAttribute = this.getAttributeName(posAttribute, "start", entity);
                    chromosomeAttribute = this.getAttributeName(chromosomeAttribute, "chromosome", entity);
                    stopAttribute = this.getAttributeName(stopAttribute, "stop", entity);
                    descriptionAttribute = this.getAttributeName(descriptionAttribute, "description", entity);
                    refAttribute = this.getAttributeName(refAttribute, "ref", entity);
                    altAttribute = this.getAttributeName(altAttribute, "alt", entity);
                    linkAttribute = this.getAttributeName(linkAttribute, "linkout", entity);
                    patientAttribute = this.getAttributeName(patientAttribute, "patient_id", entity);
                    try {
                        if (entity.getEntityType().getAttribute(posAttribute).getDataType() == AttributeType.INT) {
                            valueStart = entity.getInt(posAttribute);
                            break block17;
                        }
                        if (entity.getEntityType().getAttribute(posAttribute).getDataType() != AttributeType.LONG) break block17;
                        valueStart = Math.toIntExact(entity.getLong(posAttribute));
                    }
                    catch (ClassCastException e) {
                        LOG.debug("genomic entity has an empty start value");
                        break;
                    }
                }
                attributes = Lists.newArrayList(entity.getAttributeNames().iterator());
                if (stopAttribute != null) {
                    try {
                        if (entity.getEntityType().getAttribute("stopAttribute") == null) break block18;
                        if (entity.getEntityType().getAttribute(stopAttribute).getDataType() == AttributeType.INT) {
                            valueStop = entity.getInt(stopAttribute);
                            break block18;
                        }
                        if (entity.getEntityType().getAttribute(stopAttribute).getDataType() != AttributeType.LONG) break block18;
                        valueStop = Math.toIntExact(entity.getLong(stopAttribute));
                    }
                    catch (ClassCastException e) {
                        LOG.trace("genomic entity has an empty stop value");
                        break;
                    }
                }
            }
            valueDescription = Iterables.contains((Iterable)attributes, (Object)descriptionAttribute) ? entity.getString(descriptionAttribute) : "";
            valueLink = Iterables.contains((Iterable)attributes, (Object)linkAttribute) ? entity.getString(linkAttribute) : "";
            valuePatient = Iterables.contains((Iterable)attributes, (Object)patientAttribute) ? entity.getString(patientAttribute) : "";
            valueRef = StringUtils.isNotEmpty((CharSequence)refAttribute) && StringUtils.isNotEmpty((CharSequence)entity.getString(refAttribute)) ? entity.getString(refAttribute) : "";
            valueAlt = StringUtils.isNotEmpty((CharSequence)altAttribute) && StringUtils.isNotEmpty((CharSequence)entity.getString(altAttribute)) ? entity.getString(altAttribute) : "";
            ArrayList<String> notes = new ArrayList<String>();
            if (StringUtils.isNotEmpty((CharSequence)valueRef)) {
                notes.add(refAttribute + "~" + valueRef);
            }
            if (StringUtils.isNotEmpty((CharSequence)valueAlt)) {
                notes.add(altAttribute + "~" + valueAlt);
            }
            if (!StringUtils.isEmpty((CharSequence)valueRef) && !StringUtils.isEmpty((CharSequence)valueAlt)) {
                type = valueRef.length() == 1 && valueAlt.length() == 1 ? new DasType(valueAlt, "", "", "") : (valueRef.length() == 1 && valueAlt.length() > 1 ? new DasType("insert", "", "", "") : (valueRef.length() > 1 && valueAlt.length() == 1 ? new DasType("delete", "", "", "") : new DasType("delete", "", "", "")));
            } else if (patients.containsKey(valuePatient)) {
                type = (DasType)patients.get(valuePatient);
            } else {
                type = new DasType(score.toString(), "", "", "");
                patients.put(valuePatient, type);
                score = score + 1;
            }
            Object labelValue = entity.getLabelValue();
            DasFeature feature = this.createDasFeature(valueStart, valueStop, entity.getIdValue().toString(), labelValue != null ? labelValue.toString() : null, valueDescription, valueLink, type, this.method, dataSet, valuePatient, notes);
            features.add(feature);
        }
        DasAnnotatedSegment segment = new DasAnnotatedSegment(segmentId, Integer.valueOf(start), Integer.valueOf(stop), "1.00", segmentId, features);
        return segment;
    }

    public String getAttributeName(String attribute, String fieldName, Entity entity) {
        if (attribute == null) {
            attribute = this.config.getAttributeNameForAttributeNameArray(fieldName, entity.getEntityType());
        }
        return attribute;
    }

    protected Stream<Entity> queryDataSet(String segmentId, int browserStart, int browserStop, String dataSet, int maxbins) {
        String chromosomeAttribute = this.config.getAttributeNameForAttributeNameArray("chromosome", this.dataService.getEntityType(dataSet));
        String posAttr = this.config.getAttributeNameForAttributeNameArray("start", this.dataService.getEntityType(dataSet));
        String stopAttr = this.config.getAttributeNameForAttributeNameArray("stop", this.dataService.getEntityType(dataSet));
        Query q = new QueryImpl().eq(chromosomeAttribute, (Object)segmentId);
        q.and().nest();
        q.le(posAttr, (Object)browserStop);
        if (stopAttr != "") {
            q.and().ge(stopAttr, (Object)browserStart);
        } else {
            q.and().ge(posAttr, (Object)browserStart);
        }
        q.unnest();
        q.pageSize(maxbins);
        return this.dataService.findAll(dataSet, q);
    }

    public Integer getTotalCountForType(DasType type) throws DataSourceException {
        return 1000;
    }

    public Collection<DasType> getTypes() throws DataSourceException {
        return Collections.singleton(this.mutationType);
    }
}

