/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.l2;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.guava.CaffeinatedGuava;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityKey;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.cache.utils.EntityHydration;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.transaction.DefaultMolgenisTransactionListener;
import org.molgenis.data.transaction.MolgenisTransactionListener;
import org.molgenis.data.transaction.MolgenisTransactionManager;
import org.molgenis.data.transaction.TransactionInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class L2Cache
extends DefaultMolgenisTransactionListener {
    private static final Logger LOG = LoggerFactory.getLogger(L2Cache.class);
    private static final int MAX_CACHE_SIZE_PER_ENTITY = 1000;
    private final ConcurrentMap<String, LoadingCache<Object, Optional<Map<String, Object>>>> caches;
    private final EntityHydration entityHydration;
    private final TransactionInformation transactionInformation;

    @Autowired
    public L2Cache(MolgenisTransactionManager molgenisTransactionManager, EntityHydration entityHydration, TransactionInformation transactionInformation) {
        this.entityHydration = Objects.requireNonNull(entityHydration);
        this.transactionInformation = Objects.requireNonNull(transactionInformation);
        this.caches = Maps.newConcurrentMap();
        Objects.requireNonNull(molgenisTransactionManager).addTransactionListener((MolgenisTransactionListener)this);
    }

    public void afterCommitTransaction(String transactionId) {
        this.transactionInformation.getEntirelyDirtyRepositories().forEach(this.caches::remove);
        this.transactionInformation.getDirtyEntities().forEach(this::evict);
    }

    private void evict(EntityKey entityKey) {
        LoadingCache cache = (LoadingCache)this.caches.get(entityKey.getEntityName());
        if (cache != null) {
            cache.invalidate(entityKey.getId());
        }
    }

    public Entity get(Repository<Entity> repository, Object id) {
        LoadingCache<Object, Optional<Map<String, Object>>> cache = this.getEntityCache(repository);
        EntityType entityType = repository.getEntityType();
        return ((Optional)cache.getUnchecked(id)).map(e -> this.entityHydration.hydrate((Map<String, Object>)e, entityType)).orElse(null);
    }

    public List<Entity> getBatch(Repository<Entity> repository, Iterable<Object> ids) {
        try {
            return this.getEntityCache(repository).getAll(ids).values().stream().filter(Optional::isPresent).map(Optional::get).map(e -> this.entityHydration.hydrate((Map<String, Object>)e, repository.getEntityType())).collect(Collectors.toList());
        }
        catch (ExecutionException exception) {
            if (exception.getCause() != null && exception.getCause() instanceof RuntimeException) {
                throw (RuntimeException)exception.getCause();
            }
            throw new MolgenisDataException((Throwable)exception);
        }
    }

    @Scheduled(fixedRate=60000L)
    public void logStatistics() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cache stats:");
            for (Map.Entry cacheEntry : this.caches.entrySet()) {
                LOG.debug("{}:{}", cacheEntry.getKey(), (Object)((LoadingCache)cacheEntry.getValue()).stats());
            }
        }
    }

    private LoadingCache<Object, Optional<Map<String, Object>>> getEntityCache(Repository<Entity> repository) {
        String name = repository.getName();
        if (!this.caches.containsKey(name)) {
            this.caches.putIfAbsent(name, this.createEntityCache(repository));
        }
        return (LoadingCache)this.caches.get(name);
    }

    private LoadingCache<Object, Optional<Map<String, Object>>> createEntityCache(Repository<Entity> repository) {
        return CaffeinatedGuava.build((Caffeine)Caffeine.newBuilder().recordStats().maximumSize(1000L).expireAfterAccess(10L, TimeUnit.MINUTES), this.createCacheLoader(repository));
    }

    private CacheLoader<Object, Optional<Map<String, Object>>> createCacheLoader(final Repository<Entity> repository) {
        return new CacheLoader<Object, Optional<Map<String, Object>>>(){

            public Optional<Map<String, Object>> load(@Nonnull Object id) {
                return Optional.ofNullable(repository.findOneById(id)).map(L2Cache.this.entityHydration::dehydrate);
            }

            public Map<Object, Optional<Map<String, Object>>> loadAll(Iterable<?> ids) {
                Stream<Object> typedIds = StreamSupport.stream(ids.spliterator(), false).map(id -> id);
                Map<Object, Optional<Map<String, Object>>> result = repository.findAll(typedIds).collect(Collectors.toMap(Entity::getIdValue, this::dehydrateEntity));
                for (Object key : ids) {
                    result.putIfAbsent(key, Optional.empty());
                }
                return result;
            }

            private Optional<Map<String, Object>> dehydrateEntity(Entity entity) {
                return Optional.of(L2Cache.this.entityHydration.dehydrate(entity));
            }
        };
    }
}

