/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.l2;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityKey;
import org.molgenis.data.Fetch;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.cache.l2.L2Cache;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.transaction.TransactionInformation;

public class L2CacheRepositoryDecorator
extends AbstractRepositoryDecorator<Entity> {
    private static final int ID_BATCH_SIZE = 1000;
    private final L2Cache l2Cache;
    private final boolean cacheable;
    private final Repository<Entity> decoratedRepository;
    private final TransactionInformation transactionInformation;

    public L2CacheRepositoryDecorator(Repository<Entity> decoratedRepository, L2Cache l2Cache, TransactionInformation transactionInformation) {
        this.decoratedRepository = Objects.requireNonNull(decoratedRepository);
        this.l2Cache = Objects.requireNonNull(l2Cache);
        this.cacheable = decoratedRepository.getCapabilities().containsAll(Lists.newArrayList((Object[])new RepositoryCapability[]{RepositoryCapability.CACHEABLE}));
        this.transactionInformation = transactionInformation;
    }

    protected Repository<Entity> delegate() {
        return this.decoratedRepository;
    }

    public Entity findOneById(Object id) {
        if (this.cacheable && !this.transactionInformation.isEntireRepositoryDirty(this.getName()) && !this.transactionInformation.isEntityDirty(EntityKey.create((EntityType)this.getEntityType(), (Object)id))) {
            return this.l2Cache.get(this.delegate(), id);
        }
        return this.delegate().findOneById(id);
    }

    public Stream<Entity> findAll(Stream<Object> ids) {
        if (this.cacheable && !this.transactionInformation.isEntireRepositoryDirty(this.getName())) {
            UnmodifiableIterator idBatches = Iterators.partition(ids.iterator(), (int)1000);
            Iterator entityBatches = Iterators.transform((Iterator)idBatches, this::findAllBatch);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(entityBatches, 20), false).flatMap(Collection::stream);
        }
        return this.delegate().findAll(ids);
    }

    public Stream<Entity> findAll(Stream<Object> ids, Fetch fetch) {
        return this.findAll(ids);
    }

    public Entity findOneById(Object id, Fetch fetch) {
        return this.findOneById(id);
    }

    private List<Entity> findAllBatch(List<Object> ids) {
        String entityName = this.getEntityType().getName();
        ImmutableListMultimap partitionedIds = Multimaps.index(ids, id -> this.transactionInformation.isEntityDirty(EntityKey.create((String)entityName, (Object)id)));
        Collection cleanIds = partitionedIds.get((Object)false);
        Collection dirtyIds = partitionedIds.get((Object)true);
        HashMap result = Maps.newHashMap((Map)Maps.uniqueIndex(this.l2Cache.getBatch(this.delegate(), cleanIds), Entity::getIdValue));
        result.putAll(this.delegate().findAll(dirtyIds.stream()).collect(Collectors.toMap(Entity::getIdValue, e -> e)));
        return ids.stream().filter(result::containsKey).map(result::get).collect(Collectors.toList());
    }
}

