/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.utils;

import com.google.common.cache.Cache;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityKey;
import org.molgenis.data.cache.utils.EntityHydration;
import org.molgenis.data.meta.model.EntityType;

public class CombinedEntityCache {
    private final EntityHydration entityHydration;
    private final Cache<EntityKey, Optional<Map<String, Object>>> cache;

    public CombinedEntityCache(EntityHydration entityHydration, Cache<EntityKey, Optional<Map<String, Object>>> cache) {
        this.entityHydration = Objects.requireNonNull(entityHydration);
        this.cache = Objects.requireNonNull(cache);
    }

    public void putDeletion(EntityKey entityKey) {
        this.cache.put((Object)entityKey, Optional.empty());
    }

    public void evictAll(String entityName) {
        this.cache.asMap().keySet().stream().filter(e -> e.getEntityName().equals(entityName)).forEach(arg_0 -> this.cache.invalidate(arg_0));
    }

    @SuppressWarnings(value={"NP_OPTIONAL_RETURN_NULL"}, justification="Intentional behavior")
    public Optional<Entity> getIfPresent(EntityType entityType, Object id) {
        Optional optionalDehydratedEntity = (Optional)this.cache.getIfPresent((Object)EntityKey.create((EntityType)entityType, (Object)id));
        if (optionalDehydratedEntity == null) {
            return null;
        }
        return optionalDehydratedEntity.map(dehydratedEntity -> this.entityHydration.hydrate((Map<String, Object>)dehydratedEntity, entityType));
    }

    public void put(Entity entity) {
        String entityName = entity.getEntityType().getName();
        this.cache.put((Object)EntityKey.create((String)entityName, (Object)entity.getIdValue()), Optional.of(this.entityHydration.dehydrate(entity)));
    }

    public void evict(Stream<EntityKey> entityKeys) {
        entityKeys.forEach(arg_0 -> this.cache.invalidate(arg_0));
    }
}

