/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.l1;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.guava.CaffeinatedGuava;
import com.google.common.cache.Cache;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityKey;
import org.molgenis.data.cache.utils.CombinedEntityCache;
import org.molgenis.data.cache.utils.EntityHydration;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.transaction.DefaultMolgenisTransactionListener;
import org.molgenis.data.transaction.MolgenisTransactionListener;
import org.molgenis.data.transaction.MolgenisTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class L1Cache
extends DefaultMolgenisTransactionListener {
    private static final Logger LOG = LoggerFactory.getLogger(L1Cache.class);
    private static final int MAX_CACHE_SIZE = 1000;
    private final ThreadLocal<CombinedEntityCache> caches = new ThreadLocal();
    private final EntityHydration entityHydration;

    @Autowired
    public L1Cache(MolgenisTransactionManager molgenisTransactionManager, EntityHydration entityHydration) {
        this.entityHydration = Objects.requireNonNull(entityHydration);
        Objects.requireNonNull(molgenisTransactionManager).addTransactionListener((MolgenisTransactionListener)this);
    }

    public void transactionStarted(String transactionId) {
        LOG.trace("Creating L1 cache for transaction [{}]", (Object)transactionId);
        this.caches.set(this.createCache());
    }

    private CombinedEntityCache createCache() {
        Cache cache = CaffeinatedGuava.build((Caffeine)Caffeine.newBuilder().maximumSize(1000L).recordStats());
        return new CombinedEntityCache(this.entityHydration, (Cache<EntityKey, Optional<Map<String, Object>>>)cache);
    }

    public void doCleanupAfterCompletion(String transactionId) {
        CombinedEntityCache entityCache = this.caches.get();
        if (entityCache != null) {
            LOG.trace("Cleaning up L1 cache after transaction [{}]", (Object)transactionId);
            this.caches.remove();
        }
    }

    public void putDeletion(EntityKey entityKey) {
        CombinedEntityCache entityCache = this.caches.get();
        if (entityCache != null) {
            entityCache.putDeletion(entityKey);
        }
    }

    public void evictAll(String entityName) {
        CombinedEntityCache entityCache = this.caches.get();
        if (entityCache != null) {
            LOG.trace("Removing all entities from L1 cache that belong to {}", (Object)entityName);
            entityCache.evictAll(entityName);
        }
    }

    public void evict(Stream<EntityKey> entityKeys) {
        CombinedEntityCache entityCache = this.caches.get();
        if (entityCache != null) {
            LOG.trace("Removing entity keys from L1 cache.");
            entityCache.evict(entityKeys);
        }
    }

    @SuppressWarnings(value={"NP_OPTIONAL_RETURN_NULL"}, justification="Intentional behavior")
    public Optional<Entity> get(String entityName, Object id, EntityType entityType) {
        CombinedEntityCache cache = this.caches.get();
        if (cache == null) {
            return null;
        }
        Optional<Entity> result = cache.getIfPresent(entityType, id);
        if (result != null) {
            LOG.debug("Retrieved entity [{}] from L1 cache that belongs to {}", id, (Object)entityName);
        } else {
            LOG.trace("No entity with id [{}] present in L1 cache that belongs to {}", id, (Object)entityName);
        }
        return result;
    }

    public void put(String entityName, Entity entity) {
        CombinedEntityCache entityCache = this.caches.get();
        if (entityCache != null) {
            entityCache.put(entity);
            LOG.trace("Added dehydrated row [{}] from entity {} to the L1 cache", entity.getIdValue(), (Object)entityName);
        }
    }
}

