/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.l1;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityKey;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.cache.l1.L1Cache;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;

public class L1CacheRepositoryDecorator
extends AbstractRepositoryDecorator<Entity> {
    private static final int ID_BATCH_SIZE = 1000;
    private final Repository<Entity> decoratedRepository;
    private final L1Cache l1Cache;
    private final boolean cacheable;

    public L1CacheRepositoryDecorator(Repository<Entity> decoratedRepository, L1Cache l1Cache) {
        this.decoratedRepository = Objects.requireNonNull(decoratedRepository);
        this.l1Cache = Objects.requireNonNull(l1Cache);
        this.cacheable = decoratedRepository.getCapabilities().containsAll(Lists.newArrayList((Object[])new RepositoryCapability[]{RepositoryCapability.CACHEABLE, RepositoryCapability.WRITABLE}));
    }

    public Repository<Entity> delegate() {
        return this.decoratedRepository;
    }

    public Integer add(Stream<Entity> entities) {
        this.evictBiDiReferencedEntityTypes();
        if (this.cacheable) {
            String entityId = this.getEntityType().getId();
            entities = entities.peek(entity -> this.l1Cache.put(entityId, (Entity)entity));
        }
        return this.delegate().add(entities);
    }

    public void add(Entity entity) {
        this.evictBiDiReferencedEntities(entity);
        if (this.cacheable) {
            this.l1Cache.put(this.getEntityType().getId(), entity);
        }
        this.delegate().add(entity);
    }

    public Entity findOneById(Object id) {
        Optional<Entity> entity;
        if (this.cacheable && (entity = this.l1Cache.get(this.getEntityType().getId(), id, this.getEntityType())) != null) {
            return entity.orElse(null);
        }
        return this.delegate().findOneById(id);
    }

    public Stream<Entity> findAll(Stream<Object> ids) {
        if (this.cacheable) {
            UnmodifiableIterator idBatches = Iterators.partition(ids.iterator(), (int)1000);
            Iterator entityBatches = Iterators.transform((Iterator)idBatches, this::findAllBatch);
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(entityBatches, 20), false).flatMap(Collection::stream).filter(e -> e != null);
        }
        return this.delegate().findAll(ids);
    }

    private List<Entity> findAllBatch(List<Object> batch) {
        String entityId = this.getEntityType().getId();
        EntityType entityType = this.getEntityType();
        List missingIds = batch.stream().filter(id -> this.l1Cache.get(entityId, id, entityType) == null).collect(Collectors.toList());
        Map<Object, Entity> missingEntities = this.delegate().findAll(missingIds.stream()).collect(Collectors.toMap(Entity::getIdValue, e -> e));
        return Lists.transform(batch, id -> {
            Optional<Entity> result = this.l1Cache.get(entityId, id, this.getEntityType());
            if (result == null) {
                return (Entity)missingEntities.get(id);
            }
            return result.orElse(null);
        });
    }

    public void update(Entity entity) {
        this.evictBiDiReferencedEntityTypes();
        if (this.cacheable) {
            this.l1Cache.put(this.getEntityType().getId(), entity);
        }
        this.delegate().update(entity);
    }

    public void update(Stream<Entity> entities) {
        this.evictBiDiReferencedEntityTypes();
        if (this.cacheable) {
            entities = entities.filter(entity -> {
                this.l1Cache.put(this.getEntityType().getId(), (Entity)entity);
                return true;
            });
        }
        this.delegate().update(entities);
    }

    public void delete(Entity entity) {
        this.evictBiDiReferencedEntities(entity);
        if (this.cacheable) {
            this.l1Cache.putDeletion(EntityKey.create((Entity)entity));
        }
        this.delegate().delete(entity);
    }

    public void delete(Stream<Entity> entities) {
        this.evictBiDiReferencedEntityTypes();
        if (this.cacheable) {
            entities = entities.peek(entity -> this.l1Cache.putDeletion(EntityKey.create((Entity)entity)));
        }
        this.delegate().delete(entities);
    }

    public void deleteById(Object id) {
        this.evictBiDiReferencedEntityTypes();
        if (this.cacheable) {
            this.l1Cache.putDeletion(EntityKey.create((EntityType)this.getEntityType(), (Object)id));
        }
        this.delegate().deleteById(id);
    }

    public void deleteAll(Stream<Object> ids) {
        this.evictBiDiReferencedEntityTypes();
        if (this.cacheable) {
            EntityType entityType = this.getEntityType();
            ids = ids.peek(id -> this.l1Cache.putDeletion(EntityKey.create((EntityType)entityType, (Object)id)));
        }
        this.delegate().deleteAll(ids);
    }

    public void deleteAll() {
        this.evictBiDiReferencedEntityTypes();
        if (this.cacheable) {
            this.l1Cache.evictAll(this.getEntityType());
        }
        this.delegate().deleteAll();
    }

    private void evictBiDiReferencedEntityTypes() {
        this.getEntityType().getMappedByAttributes().map(Attribute::getRefEntity).forEach(this.l1Cache::evictAll);
        this.getEntityType().getInversedByAttributes().map(Attribute::getRefEntity).forEach(this.l1Cache::evictAll);
    }

    private void evictBiDiReferencedEntities(Entity entity) {
        Stream<EntityKey> backreffingEntities = this.getEntityType().getMappedByAttributes().flatMap(mappedByAttr -> StreamSupport.stream(entity.getEntities(mappedByAttr.getName()).spliterator(), false)).map(EntityKey::create);
        Stream<EntityKey> manyToOneEntities = this.getEntityType().getInversedByAttributes().map(inversedByAttr -> entity.getEntity(inversedByAttr.getName())).filter(refEntity -> refEntity != null).map(EntityKey::create);
        this.l1Cache.evict(Stream.concat(backreffingEntities, manyToOneEntities));
    }
}

