/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.l3;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.guava.CaffeinatedGuava;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.molgenis.data.Entity;
import org.molgenis.data.Fetch;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.transaction.DefaultMolgenisTransactionListener;
import org.molgenis.data.transaction.MolgenisTransactionListener;
import org.molgenis.data.transaction.MolgenisTransactionManager;
import org.molgenis.data.transaction.TransactionInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class L3Cache
extends DefaultMolgenisTransactionListener {
    private static final Logger LOG = LoggerFactory.getLogger(L3Cache.class);
    private static final int MAX_CACHE_SIZE_PER_QUERY = 1000;
    private final ConcurrentMap<String, LoadingCache<Query<Entity>, List<Object>>> caches = Maps.newConcurrentMap();
    private final TransactionInformation transactionInformation;

    @Autowired
    public L3Cache(MolgenisTransactionManager molgenisTransactionManager, TransactionInformation transactionInformation) {
        this.transactionInformation = Objects.requireNonNull(transactionInformation);
        Objects.requireNonNull(molgenisTransactionManager).addTransactionListener((MolgenisTransactionListener)this);
    }

    public void afterCommitTransaction(String transactionId) {
        this.transactionInformation.getDirtyRepositories().forEach(this.caches::remove);
    }

    public List<Object> get(Repository<Entity> repository, Query<Entity> query) {
        LoadingCache<Query<Entity>, List<Object>> cache = this.getQueryCache(repository);
        QueryImpl fetchlessQuery = new QueryImpl(query);
        fetchlessQuery.setFetch(null);
        return (List)cache.getUnchecked((Object)fetchlessQuery);
    }

    private LoadingCache<Query<Entity>, List<Object>> getQueryCache(Repository<Entity> repository) {
        String id = repository.getEntityType().getId();
        if (!this.caches.containsKey(id)) {
            this.caches.putIfAbsent(id, this.createQueryCache(repository));
        }
        return (LoadingCache)this.caches.get(id);
    }

    private LoadingCache<Query<Entity>, List<Object>> createQueryCache(Repository<Entity> repository) {
        LOG.trace("Creating Query cache for repository {}", (Object)repository.getName());
        return CaffeinatedGuava.build((Caffeine)Caffeine.newBuilder().recordStats().maximumSize(1000L).expireAfterAccess(10L, TimeUnit.MINUTES), this.createCacheLoader(repository));
    }

    private CacheLoader<Query<Entity>, List<Object>> createCacheLoader(final Repository<Entity> repository) {
        final String repositoryName = repository.getName();
        final Fetch idAttributeFetch = new Fetch().field(repository.getEntityType().getIdAttribute().getName());
        return new CacheLoader<Query<Entity>, List<Object>>(){

            public List<Object> load(@Nonnull Query<Entity> query) {
                LOG.trace("Loading identifiers from repository {} for query {}", (Object)repositoryName, query);
                return repository.findAll(new QueryImpl(query).fetch(idAttributeFetch)).map(Entity::getIdValue).collect(Collectors.toList());
            }
        };
    }

    @Scheduled(fixedRate=60000L)
    public void logStatistics() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cache stats:");
            for (Map.Entry cacheEntry : this.caches.entrySet()) {
                LOG.debug("{}:{}", cacheEntry.getKey(), (Object)((LoadingCache)cacheEntry.getValue()).stats());
            }
        }
    }
}

