/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityManager;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.EntityTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EntityHydration {
    private static final Logger LOG = LoggerFactory.getLogger(EntityHydration.class);
    private final EntityManager entityManager;

    @Autowired
    public EntityHydration(EntityManager entityManager) {
        this.entityManager = Objects.requireNonNull(entityManager);
    }

    public Entity hydrate(Map<String, Object> dehydratedEntity, EntityType entityType) {
        LOG.trace("Hydrating entity: {} for entity {}", dehydratedEntity, (Object)entityType.getId());
        Entity hydratedEntity = this.entityManager.create(entityType, EntityManager.CreationMode.NO_POPULATE);
        for (Attribute attribute : entityType.getAtomicAttributes()) {
            if (attribute.getExpression() != null) continue;
            String name = attribute.getName();
            Object value = dehydratedEntity.get(name);
            if (value != null) {
                if (EntityTypeUtils.isMultipleReferenceType((Attribute)attribute)) {
                    value = this.entityManager.getReferences(attribute.getRefEntity(), (Iterable)((List)value));
                } else if (EntityTypeUtils.isSingleReferenceType((Attribute)attribute)) {
                    value = this.entityManager.getReference(attribute.getRefEntity(), value);
                }
            }
            hydratedEntity.set(name, value);
        }
        return hydratedEntity;
    }

    public Map<String, Object> dehydrate(Entity entity) {
        LOG.trace("Dehydrating entity {}", (Object)entity);
        HashMap dehydratedEntity = Maps.newHashMap();
        EntityType entityType = entity.getEntityType();
        entityType.getAtomicAttributes().forEach(attribute -> {
            if (!attribute.hasExpression()) {
                String name = attribute.getName();
                AttributeType type = attribute.getDataType();
                dehydratedEntity.put(name, EntityHydration.getValueBasedOnType(entity, name, type));
            }
        });
        return dehydratedEntity;
    }

    private static Object getValueBasedOnType(Entity entity, String name, AttributeType type) {
        Object value;
        switch (type) {
            case CATEGORICAL: 
            case FILE: 
            case XREF: {
                Entity xrefEntity = entity.getEntity(name);
                value = xrefEntity != null ? xrefEntity.getIdValue() : null;
                break;
            }
            case CATEGORICAL_MREF: 
            case MREF: 
            case ONE_TO_MANY: {
                ArrayList mrefIdentifiers = Lists.newArrayList();
                entity.getEntities(name).forEach(mrefEntity -> {
                    if (mrefEntity != null) {
                        mrefIdentifiers.add(mrefEntity.getIdValue());
                    }
                });
                value = mrefIdentifiers;
                break;
            }
            case DATE: {
                value = entity.getLocalDate(name);
                break;
            }
            case DATE_TIME: {
                value = entity.getInstant(name);
                break;
            }
            case BOOL: 
            case DECIMAL: 
            case EMAIL: 
            case ENUM: 
            case HTML: 
            case HYPERLINK: 
            case INT: 
            case LONG: 
            case SCRIPT: 
            case STRING: 
            case TEXT: {
                value = entity.get(name);
                break;
            }
            case COMPOUND: {
                throw new RuntimeException(String.format("Illegal attribute type [%s]", type.toString()));
            }
            default: {
                throw new RuntimeException(String.format("Unknown attribute type [%s]", type));
            }
        }
        LOG.trace("Dehydrating attribute '{}' of type [{}] resulted in value: {}", new Object[]{name, type.toString(), value});
        return value;
    }
}

