/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.l3;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.cache.l3.L3Cache;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.transaction.TransactionInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L3CacheRepositoryDecorator
extends AbstractRepositoryDecorator<Entity> {
    private static final Logger LOG = LoggerFactory.getLogger(L3CacheRepositoryDecorator.class);
    private final L3Cache l3Cache;
    private final boolean cacheable;
    private final TransactionInformation transactionInformation;
    private static final int MAX_PAGE_SIZE = 1000;

    public L3CacheRepositoryDecorator(Repository<Entity> delegateRepository, L3Cache l3Cache, TransactionInformation transactionInformation) {
        super(delegateRepository);
        this.l3Cache = Objects.requireNonNull(l3Cache);
        this.cacheable = delegateRepository.getCapabilities().containsAll(Lists.newArrayList((Object[])new RepositoryCapability[]{RepositoryCapability.CACHEABLE}));
        this.transactionInformation = Objects.requireNonNull(transactionInformation);
    }

    public Stream<Entity> findAll(Query<Entity> query) {
        if (this.transactionInformation.isRepositoryCompletelyClean(this.getEntityType())) {
            if (this.cacheable && query.getPageSize() > 0 && query.getPageSize() <= 1000) {
                List<Object> ids = this.l3Cache.get((Repository<Entity>)this.delegate(), query);
                return this.delegate().findAll(ids.stream(), query.getFetch());
            }
        } else {
            LOG.debug("Repository is dirty: {}", (Object)this.getName());
        }
        return this.delegate().findAll(query);
    }

    public Entity findOne(Query<Entity> query) {
        if (this.transactionInformation.isRepositoryCompletelyClean(this.getEntityType()) && this.cacheable) {
            QueryImpl cacheKey = new QueryImpl(query).setPageSize(1);
            List<Object> ids = this.l3Cache.get((Repository<Entity>)this.delegate(), (Query<Entity>)cacheKey);
            if (ids.isEmpty()) {
                return null;
            }
            return this.delegate().findOneById(ids.get(0), query.getFetch());
        }
        return this.delegate().findOne(query);
    }
}

