/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.utils;

import java.util.Objects;
import javax.annotation.Nullable;

public class CacheHit<T> {
    private static final CacheHit<?> EMPTY = new CacheHit<Object>(null);
    @Nullable
    private T value;

    private CacheHit(@Nullable T value) {
        this.value = value;
    }

    public static <T> CacheHit<T> empty() {
        CacheHit<?> hit = EMPTY;
        return hit;
    }

    public static <T> CacheHit<T> of(T value) {
        CacheHit<T> hit = new CacheHit<T>(Objects.requireNonNull(value));
        return hit;
    }

    @Nullable
    public T getValue() {
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheHit)) {
            return false;
        }
        CacheHit cacheHit = (CacheHit)o;
        return Objects.equals(this.getValue(), cacheHit.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }

    public String toString() {
        return "CacheHit{value=" + this.value + '}';
    }
}

