/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.utils;

import com.google.common.cache.Cache;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityKey;
import org.molgenis.data.cache.utils.CacheHit;
import org.molgenis.data.cache.utils.EntityHydration;
import org.molgenis.data.meta.model.EntityType;

public class CombinedEntityCache {
    private final EntityHydration entityHydration;
    private final Cache<EntityKey, CacheHit<Map<String, Object>>> cache;

    public CombinedEntityCache(EntityHydration entityHydration, Cache<EntityKey, CacheHit<Map<String, Object>>> cache) {
        this.entityHydration = Objects.requireNonNull(entityHydration);
        this.cache = Objects.requireNonNull(cache);
    }

    public void putDeletion(EntityKey entityKey) {
        this.cache.put((Object)entityKey, CacheHit.empty());
    }

    public void evictAll(EntityType entityType) {
        this.cache.asMap().keySet().stream().filter(e -> e.getEntityTypeId().equals(entityType.getId())).forEach(arg_0 -> this.cache.invalidate(arg_0));
    }

    public Optional<CacheHit<Entity>> getIfPresent(EntityType entityType, Object id) {
        EntityKey key = EntityKey.create((EntityType)entityType, (Object)id);
        return Optional.ofNullable((CacheHit)this.cache.getIfPresent((Object)key)).map(cacheHit -> this.hydrate((CacheHit<Map<String, Object>>)cacheHit, entityType));
    }

    public void put(Entity entity) {
        EntityType entityType = entity.getEntityType();
        this.cache.put((Object)EntityKey.create((EntityType)entityType, (Object)entity.getIdValue()), CacheHit.of(this.entityHydration.dehydrate(entity)));
    }

    public void evict(Stream<EntityKey> entityKeys) {
        entityKeys.forEach(arg_0 -> this.cache.invalidate(arg_0));
    }

    private CacheHit<Entity> hydrate(CacheHit<Map<String, Object>> cacheHitAsMap, EntityType entityType) {
        if (cacheHitAsMap.isEmpty()) {
            return CacheHit.empty();
        }
        return CacheHit.of(this.entityHydration.hydrate(cacheHitAsMap.getValue(), entityType));
    }
}

