/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.l1;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.guava.CaffeinatedGuava;
import com.google.common.cache.Cache;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityKey;
import org.molgenis.data.Fetch;
import org.molgenis.data.cache.utils.CacheHit;
import org.molgenis.data.cache.utils.CombinedEntityCache;
import org.molgenis.data.cache.utils.EntityHydration;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.transaction.TransactionListener;
import org.molgenis.data.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class L1Cache
implements TransactionListener {
    private static final Logger LOG = LoggerFactory.getLogger(L1Cache.class);
    private static final int MAX_CACHE_SIZE = 25000;
    private final ThreadLocal<CombinedEntityCache> caches = new ThreadLocal();
    private final EntityHydration entityHydration;

    L1Cache(TransactionManager transactionManager, EntityHydration entityHydration) {
        this.entityHydration = Objects.requireNonNull(entityHydration);
        Objects.requireNonNull(transactionManager).addTransactionListener((TransactionListener)this);
    }

    public void transactionStarted(String transactionId) {
        LOG.trace("Creating L1 cache for transaction [{}]", (Object)transactionId);
        this.caches.set(this.createCache());
    }

    private CombinedEntityCache createCache() {
        Cache cache = CaffeinatedGuava.build((Caffeine)Caffeine.newBuilder().maximumSize(25000L).recordStats());
        return new CombinedEntityCache(this.entityHydration, (Cache<EntityKey, CacheHit<Map<String, Object>>>)cache);
    }

    public void doCleanupAfterCompletion(String transactionId) {
        CombinedEntityCache entityCache = this.caches.get();
        if (entityCache != null) {
            LOG.trace("Cleaning up L1 cache after transaction [{}]", (Object)transactionId);
            this.caches.remove();
        }
    }

    void putDeletion(Entity entity) {
        CombinedEntityCache entityCache = this.caches.get();
        if (entityCache != null) {
            EntityKey entityKey = EntityKey.create((String)entity.getEntityType().getId(), (Object)entity.getIdValue());
            entityCache.putDeletion(entityKey);
        }
    }

    void putDeletion(EntityType entityType, Object entityId) {
        CombinedEntityCache entityCache = this.caches.get();
        if (entityCache != null) {
            EntityKey entityKey = EntityKey.create((String)entityType.getId(), (Object)entityId);
            entityCache.putDeletion(entityKey);
        }
    }

    void evict(Entity entity) {
        CombinedEntityCache entityCache = this.caches.get();
        if (entityCache != null) {
            entityCache.evict(Stream.of(EntityKey.create((String)entity.getEntityType().getId(), (Object)entity.getIdValue())));
        }
    }

    void evictAll(EntityType entityType) {
        CombinedEntityCache entityCache = this.caches.get();
        if (entityCache != null) {
            LOG.trace("Removing all entities from L1 cache that belong to {}", (Object)entityType.getId());
            entityCache.evictAll(entityType);
        }
    }

    public Optional<CacheHit<Entity>> get(EntityType entityType, Object entityId) {
        return this.get(entityType, entityId, null);
    }

    public Optional<CacheHit<Entity>> get(EntityType entityType, Object entityId, @Nullable @CheckForNull Fetch fetch) {
        CombinedEntityCache cache = this.caches.get();
        if (cache == null) {
            return Optional.empty();
        }
        Optional<CacheHit<Entity>> result = cache.getIfPresent(entityType, entityId, fetch);
        if (LOG.isDebugEnabled()) {
            if (result.isPresent()) {
                LOG.debug("Retrieved entity [{}] from L1 cache that belongs to {}", entityId, (Object)entityType.getId());
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("No entity with id [{}] present in L1 cache that belongs to {}", entityId, (Object)entityType.getId());
            }
        }
        return result;
    }

    public void put(Entity entity) {
        CombinedEntityCache entityCache = this.caches.get();
        if (entityCache != null) {
            entityCache.put(entity);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Added dehydrated row [{}] from entity {} to the L1 cache", entity.getIdValue(), (Object)entity.getEntityType().getId());
            }
        }
    }
}

