/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.l1;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.data.Entity;
import org.molgenis.data.cache.l1.L1Cache;
import org.molgenis.data.cache.l1.L1CacheJanitor;
import org.molgenis.data.cache.utils.CacheHit;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.util.EntityUtils;
import org.springframework.stereotype.Component;

@Component
public class L1CacheJanitorImpl
implements L1CacheJanitor {
    private final L1Cache l1Cache;

    public L1CacheJanitorImpl(L1Cache l1Cache) {
        this.l1Cache = Objects.requireNonNull(l1Cache);
    }

    @Override
    public void cleanCacheBeforeAdd(Entity entity) {
        this.cleanCacheBeforeAddOrDelete(entity);
    }

    @Override
    public Stream<Entity> cleanCacheBeforeAdd(EntityType entityType, Stream<Entity> entityStream) {
        return this.cleanCacheBeforeAddOrDelete(entityType, entityStream);
    }

    private void cleanCacheBeforeAddOrDelete(Attribute attribute, Entity entity) {
        Entity refEntity = entity.getEntity(attribute);
        if (refEntity != null && !EntityUtils.isSame((Entity)entity, (Entity)refEntity)) {
            this.l1Cache.evict(refEntity);
        }
    }

    @Override
    public void cleanCacheBeforeUpdate(Entity entity) {
        EntityType entityType = entity.getEntityType();
        Iterator iterator = entityType.getInversedByAttributes().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Entity currentEntity = this.l1Cache.get(entityType, entity.getIdValue()).map(CacheHit::getValue).orElse(null);
        do {
            this.cleanCacheBeforeUpdate((Attribute)iterator.next(), entity, currentEntity);
        } while (iterator.hasNext());
    }

    @Override
    public Stream<Entity> cleanCacheBeforeUpdate(EntityType entityType, Stream<Entity> entityStream) {
        List attributes = entityType.getInversedByAttributes().collect(Collectors.toList());
        if (attributes.isEmpty()) {
            return entityStream;
        }
        return entityStream.filter(entity -> {
            Entity currentEntity = this.l1Cache.get(entityType, entity.getIdValue()).map(CacheHit::getValue).orElse(null);
            attributes.forEach(attribute -> this.cleanCacheBeforeUpdate((Attribute)attribute, (Entity)entity, currentEntity));
            return true;
        });
    }

    private void cleanCacheBeforeUpdate(Attribute attribute, Entity updatedEntity, @Nullable @CheckForNull Entity currentEntity) {
        if (currentEntity == null) {
            this.l1Cache.evictAll(attribute.getRefEntity());
        } else {
            Entity currentRefEntity = currentEntity.getEntity(attribute);
            Entity updatedRefEntity = updatedEntity.getEntity(attribute);
            if (currentRefEntity == null) {
                if (updatedRefEntity != null && !EntityUtils.isSame((Entity)updatedEntity, (Entity)updatedRefEntity)) {
                    this.l1Cache.evict(updatedRefEntity);
                }
            } else {
                this.cleanCacheBeforeUpdateRefEntity(updatedEntity, currentRefEntity, updatedRefEntity);
            }
        }
    }

    private void cleanCacheBeforeUpdateRefEntity(Entity updatedEntity, Entity currentRefEntity, Entity updatedRefEntity) {
        if (updatedRefEntity == null) {
            if (!EntityUtils.isSame((Entity)updatedEntity, (Entity)currentRefEntity)) {
                this.l1Cache.evict(currentRefEntity);
            }
        } else if (!EntityUtils.isSame((Entity)currentRefEntity, (Entity)updatedRefEntity)) {
            if (!EntityUtils.isSame((Entity)updatedEntity, (Entity)updatedRefEntity)) {
                this.l1Cache.evict(updatedRefEntity);
            }
            if (!EntityUtils.isSame((Entity)updatedEntity, (Entity)currentRefEntity)) {
                this.l1Cache.evict(currentRefEntity);
            }
        }
    }

    @Override
    public void cleanCacheBeforeDelete(Entity entity) {
        this.cleanCacheBeforeAddOrDelete(entity);
    }

    @Override
    public Stream<Entity> cleanCacheBeforeDelete(EntityType entityType, Stream<Entity> entityStream) {
        return this.cleanCacheBeforeAddOrDelete(entityType, entityStream);
    }

    @Override
    public void cleanCacheBeforeDeleteById(EntityType entityType, Object entityId) {
        Iterator iterator = entityType.getInversedByAttributes().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        Entity entity = this.l1Cache.get(entityType, entityId).map(CacheHit::getValue).orElse(null);
        do {
            this.cleanCacheBeforeDeleteById((Attribute)iterator.next(), entity);
        } while (iterator.hasNext());
    }

    @Override
    public Stream<Object> cleanCacheBeforeDeleteById(EntityType entityType, Stream<Object> entityIdStream) {
        List attributes = entityType.getInversedByAttributes().collect(Collectors.toList());
        if (attributes.isEmpty()) {
            return entityIdStream;
        }
        return entityIdStream.filter(entityId -> {
            Entity entity = this.l1Cache.get(entityType, entityId).map(CacheHit::getValue).orElse(null);
            attributes.forEach(attribute -> this.cleanCacheBeforeDeleteById((Attribute)attribute, entity));
            return true;
        });
    }

    private void cleanCacheBeforeDeleteById(Attribute attribute, @Nullable @CheckForNull Entity entity) {
        if (entity == null) {
            this.l1Cache.evictAll(attribute.getRefEntity());
        } else {
            this.cleanCacheBeforeAddOrDelete(attribute, entity);
        }
    }

    @Override
    public void cleanCacheBeforeDeleteAll(EntityType entityType) {
    }

    private void cleanCacheBeforeAddOrDelete(Entity entity) {
        Iterator iterator = entity.getEntityType().getInversedByAttributes().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        do {
            this.cleanCacheBeforeAddOrDelete((Attribute)iterator.next(), entity);
        } while (iterator.hasNext());
    }

    private Stream<Entity> cleanCacheBeforeAddOrDelete(EntityType entityType, Stream<Entity> entityStream) {
        List attributes = entityType.getInversedByAttributes().collect(Collectors.toList());
        if (attributes.isEmpty()) {
            return entityStream;
        }
        return entityStream.filter(entity -> {
            attributes.forEach(attribute -> this.cleanCacheBeforeAddOrDelete((Attribute)attribute, (Entity)entity));
            return true;
        });
    }
}

