/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.l1;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Fetch;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.cache.l1.L1Cache;
import org.molgenis.data.cache.l1.L1CacheJanitor;
import org.molgenis.data.cache.utils.CacheHit;
import org.molgenis.data.meta.model.EntityType;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class L1CacheRepositoryDecorator
extends AbstractRepositoryDecorator<Entity> {
    private static final int BATCH_SIZE = 1000;
    private final L1Cache l1Cache;
    private final L1CacheJanitor l1CacheJanitor;
    private final boolean cacheable;

    public L1CacheRepositoryDecorator(Repository<Entity> delegateRepository, L1Cache l1Cache, L1CacheJanitor l1CacheJanitor) {
        super(delegateRepository);
        this.l1Cache = Objects.requireNonNull(l1Cache);
        this.l1CacheJanitor = Objects.requireNonNull(l1CacheJanitor);
        this.cacheable = delegateRepository.getCapabilities().contains(RepositoryCapability.CACHEABLE);
    }

    public void add(Entity entity) {
        if (this.useCache()) {
            this.l1CacheJanitor.cleanCacheBeforeAdd(entity);
            this.putCache(entity);
        }
        this.delegate().add(entity);
    }

    public Integer add(Stream<Entity> entities) {
        if (this.useCache()) {
            entities = this.l1CacheJanitor.cleanCacheBeforeAdd(this.getEntityType(), entities).filter(this::putCache);
        }
        return this.delegate().add(entities);
    }

    public Entity findOneById(Object id) {
        return this.useCache() ? this.findOneByIdWithCache(id, null) : this.delegate().findOneById(id);
    }

    public Entity findOneById(Object id, Fetch fetch) {
        return this.useCache() ? this.findOneByIdWithCache(id, fetch) : this.delegate().findOneById(id, fetch);
    }

    private Entity findOneByIdWithCache(Object id, @Nullable @CheckForNull Fetch fetch) {
        EntityType entityType = this.getEntityType();
        Optional<CacheHit<Entity>> cacheHit = this.l1Cache.get(entityType, id, fetch);
        if (cacheHit.isPresent()) {
            return cacheHit.get().getValue();
        }
        Entity entity = this.delegate().findOneById(id);
        if (entity != null) {
            this.l1Cache.put(entity);
        } else {
            this.l1Cache.putDeletion(entityType, id);
        }
        return entity;
    }

    public Stream<Entity> findAll(Stream<Object> ids) {
        return this.useCache() ? this.findAllWithCache(ids, null) : this.delegate().findAll(ids);
    }

    public Stream<Entity> findAll(Stream<Object> ids, Fetch fetch) {
        return this.useCache() ? this.findAllWithCache(ids, fetch) : this.delegate().findAll(ids, fetch);
    }

    private Stream<Entity> findAllWithCache(Stream<Object> ids, @Nullable @CheckForNull Fetch fetch) {
        UnmodifiableIterator idBatches = Iterators.partition(ids.iterator(), (int)1000);
        return Streams.stream((Iterator)idBatches).map(idBatch -> this.findAllWithCache((List<Object>)idBatch, fetch)).flatMap(Collection::stream).filter(Objects::nonNull);
    }

    private Collection<Entity> findAllWithCache(List<Object> entityIds, @Nullable @CheckForNull Fetch fetch) {
        EntityType entityType = this.getEntityType();
        ArrayList<Object> missingEntityIds = null;
        LinkedHashMap entityMap = Maps.newLinkedHashMapWithExpectedSize((int)entityIds.size());
        for (Object entityId : entityIds) {
            Optional<CacheHit<Entity>> optionalCacheHit = this.l1Cache.get(entityType, entityId, fetch);
            if (optionalCacheHit.isPresent()) {
                entityMap.put(entityId, optionalCacheHit.get().getValue());
                continue;
            }
            entityMap.put(entityId, null);
            if (missingEntityIds == null) {
                missingEntityIds = new ArrayList<Object>(entityIds.size());
            }
            missingEntityIds.add(entityId);
        }
        if (missingEntityIds != null && !missingEntityIds.isEmpty()) {
            Stream entityStream = this.delegate().findAll(missingEntityIds.stream());
            entityStream.forEach(entity -> {
                entityMap.put(entity.getIdValue(), entity);
                this.l1Cache.put((Entity)entity);
            });
        }
        return entityMap.values();
    }

    public void update(Entity entity) {
        if (this.useCache()) {
            this.l1CacheJanitor.cleanCacheBeforeUpdate(entity);
            this.putCache(entity);
        }
        this.delegate().update(entity);
    }

    public void update(Stream<Entity> entities) {
        if (this.useCache()) {
            entities = this.l1CacheJanitor.cleanCacheBeforeUpdate(this.getEntityType(), entities).filter(this::putCache);
        }
        this.delegate().update(entities);
    }

    public void delete(Entity entity) {
        if (this.useCache()) {
            this.l1CacheJanitor.cleanCacheBeforeDelete(entity);
            this.delCache(entity);
        }
        this.delegate().delete(entity);
    }

    public void delete(Stream<Entity> entities) {
        if (this.useCache()) {
            entities = this.l1CacheJanitor.cleanCacheBeforeDelete(this.getEntityType(), entities).filter(this::delCache);
        }
        this.delegate().delete(entities);
    }

    public void deleteById(Object id) {
        if (this.useCache()) {
            EntityType entityType = this.getEntityType();
            this.l1CacheJanitor.cleanCacheBeforeDeleteById(entityType, id);
            this.delCache(entityType, id);
        }
        this.delegate().deleteById(id);
    }

    public void deleteAll(Stream<Object> ids) {
        if (this.useCache()) {
            EntityType entityType = this.getEntityType();
            ids = this.l1CacheJanitor.cleanCacheBeforeDeleteById(entityType, ids).filter(id -> this.delCache(entityType, id));
        }
        this.delegate().deleteAll(ids);
    }

    public void deleteAll() {
        if (this.useCache()) {
            EntityType entityType = this.getEntityType();
            this.l1CacheJanitor.cleanCacheBeforeDeleteAll(entityType);
            this.l1Cache.evictAll(entityType);
        }
        this.delegate().deleteAll();
    }

    private boolean putCache(Entity entity) {
        this.l1Cache.put(entity);
        return true;
    }

    private boolean delCache(Entity entity) {
        this.l1Cache.putDeletion(entity);
        return true;
    }

    private boolean delCache(EntityType entityType, Object entityId) {
        this.l1Cache.putDeletion(entityType, entityId);
        return true;
    }

    private boolean useCache() {
        return this.cacheable && !TransactionSynchronizationManager.isCurrentTransactionReadOnly();
    }
}

