/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.cache.l2;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityKey;
import org.molgenis.data.Fetch;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.cache.l2.L2Cache;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.transaction.TransactionInformation;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class L2CacheRepositoryDecorator
extends AbstractRepositoryDecorator<Entity> {
    private static final int ID_BATCH_SIZE = 1000;
    private final L2Cache l2Cache;
    private final boolean cacheable;
    private final TransactionInformation transactionInformation;

    public L2CacheRepositoryDecorator(Repository<Entity> delegateRepository, L2Cache l2Cache, TransactionInformation transactionInformation) {
        super(delegateRepository);
        this.l2Cache = Objects.requireNonNull(l2Cache);
        this.cacheable = delegateRepository.getCapabilities().containsAll(Lists.newArrayList((Object[])new RepositoryCapability[]{RepositoryCapability.CACHEABLE}));
        this.transactionInformation = transactionInformation;
    }

    public Entity findOneById(Object id) {
        if (this.doRetrieveFromCache(id)) {
            return this.l2Cache.get((Repository<Entity>)this.delegate(), id);
        }
        return this.delegate().findOneById(id);
    }

    public Stream<Entity> findAll(Stream<Object> ids) {
        if (this.doRetrieveFromCache()) {
            UnmodifiableIterator batches = Iterators.partition(ids.iterator(), (int)1000);
            Iterable iterable = () -> L2CacheRepositoryDecorator.lambda$findAll$0((Iterator)batches);
            return Streams.stream(iterable).flatMap(batch -> this.findAllCache((List<Object>)batch).stream());
        }
        return this.delegate().findAll(ids);
    }

    public Stream<Entity> findAll(Stream<Object> ids, Fetch fetch) {
        if (this.doRetrieveFromCache()) {
            UnmodifiableIterator batches = Iterators.partition(ids.iterator(), (int)1000);
            Iterable iterable = () -> L2CacheRepositoryDecorator.lambda$findAll$2((Iterator)batches);
            return Streams.stream(iterable).flatMap(batch -> this.findAllCache((List<Object>)batch, fetch).stream());
        }
        return this.delegate().findAll(ids, fetch);
    }

    public Entity findOneById(Object id, Fetch fetch) {
        if (this.doRetrieveFromCache(id)) {
            return this.l2Cache.get((Repository<Entity>)this.delegate(), id, fetch);
        }
        return this.delegate().findOneById(id, fetch);
    }

    private boolean doRetrieveFromCache() {
        return this.cacheable && (TransactionSynchronizationManager.isCurrentTransactionReadOnly() || !this.transactionInformation.isEntireRepositoryDirty(this.getEntityType()));
    }

    private boolean doRetrieveFromCache(Object id) {
        return this.cacheable && (TransactionSynchronizationManager.isCurrentTransactionReadOnly() || !this.transactionInformation.isEntireRepositoryDirty(this.getEntityType()) && !this.transactionInformation.isEntityDirty(EntityKey.create((EntityType)this.getEntityType(), (Object)id)));
    }

    private List<Entity> findAllCache(List<Object> ids) {
        if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            List<Entity> unorderedEntities = this.l2Cache.getBatch((Repository<Entity>)this.delegate(), ids);
            return this.createOrderedEntities(ids, unorderedEntities);
        }
        String entityTypeId = this.getEntityType().getId();
        ImmutableListMultimap partitionedIds = Multimaps.index(ids, id -> this.transactionInformation.isEntityDirty(EntityKey.create((String)entityTypeId, (Object)id)));
        Collection cleanIds = partitionedIds.get((Object)false);
        Collection dirtyIds = partitionedIds.get((Object)true);
        HashMap result = Maps.newHashMap((Map)Maps.uniqueIndex(this.l2Cache.getBatch((Repository<Entity>)this.delegate(), cleanIds), Entity::getIdValue));
        result.putAll(this.delegate().findAll(dirtyIds.stream()).collect(Collectors.toMap(Entity::getIdValue, e -> e)));
        return ids.stream().filter(result::containsKey).map(result::get).collect(Collectors.toList());
    }

    private List<Entity> findAllCache(List<Object> ids, Fetch fetch) {
        if (TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            List<Entity> unorderedEntities = this.l2Cache.getBatch((Repository<Entity>)this.delegate(), ids, fetch);
            return this.createOrderedEntities(ids, unorderedEntities);
        }
        String entityTypeId = this.getEntityType().getId();
        ImmutableListMultimap partitionedIds = Multimaps.index(ids, id -> this.transactionInformation.isEntityDirty(EntityKey.create((String)entityTypeId, (Object)id)));
        Collection cleanIds = partitionedIds.get((Object)false);
        Collection dirtyIds = partitionedIds.get((Object)true);
        List<Entity> batch = this.l2Cache.getBatch((Repository<Entity>)this.delegate(), cleanIds, fetch);
        HashMap result = Maps.newHashMap((Map)Maps.uniqueIndex(batch, Entity::getIdValue));
        result.putAll(this.delegate().findAll(dirtyIds.stream(), fetch).collect(Collectors.toMap(Entity::getIdValue, e -> e)));
        return ids.stream().filter(result::containsKey).map(result::get).collect(Collectors.toList());
    }

    private List<Entity> createOrderedEntities(List<Object> ids, List<Entity> unorderedEntities) {
        HashMap entityIndex = Maps.newHashMapWithExpectedSize((int)ids.size());
        unorderedEntities.forEach(entity -> entityIndex.put(entity.getIdValue(), entity));
        ArrayList<Entity> orderedEntities = new ArrayList<Entity>(ids.size());
        ids.forEach(id -> orderedEntities.add((Entity)entityIndex.get(id)));
        return orderedEntities;
    }

    private static /* synthetic */ Iterator lambda$findAll$2(Iterator batches) {
        return batches;
    }

    private static /* synthetic */ Iterator lambda$findAll$0(Iterator batches) {
        return batches;
    }
}

