/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.icd10;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.icd10.CollectionsQueryTransformerImpl;
import org.molgenis.data.icd10.Icd10ClassExpander;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.test.AbstractMockitoTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CollectionsQueryTransformerImplTest
extends AbstractMockitoTest {
    @Mock
    private DataService dataService;
    @Mock
    private Icd10ClassExpander icd10ClassExpander;
    private CollectionsQueryTransformerImpl collectionsQueryTransformerImpl;
    private List<Entity> expandedDiseaseEntities;
    private Entity diseaseEntity;

    @BeforeMethod
    public void setUpBeforeMethod() {
        this.collectionsQueryTransformerImpl = new CollectionsQueryTransformerImpl(this.icd10ClassExpander, this.dataService);
    }

    private void setExpandedDiseaseEntities() {
        this.diseaseEntity = (Entity)Mockito.mock(Entity.class);
        Entity expandedDiseaseEntity = (Entity)Mockito.mock(Entity.class);
        this.expandedDiseaseEntities = Arrays.asList(this.diseaseEntity, expandedDiseaseEntity);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testBbmriEricCollectionsQueryTransformerImpl() {
        new CollectionsQueryTransformerImpl(null, null);
    }

    @DataProvider(name="nonTransformableQueryProvider")
    public Iterator<Object[]> nonTransformableQueryProvider() {
        this.setExpandedDiseaseEntities();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        Query query = new QueryImpl().eq("field", (Object)"value");
        dataList.add(new Object[]{query, query});
        query = new QueryImpl().search("value").or().eq("field", (Object)"value");
        dataList.add(new Object[]{query, query});
        query = new QueryImpl().search("disease");
        dataList.add(new Object[]{query, query});
        return dataList.iterator();
    }

    @Test(dataProvider="nonTransformableQueryProvider")
    public void testNonTransformableQueries(Query<Entity> query, Query<Entity> expectedTransformedQuery) {
        Query transformedQuery = this.collectionsQueryTransformerImpl.transformQuery(query, "icd10Entity", "expandAttribute");
        Assert.assertEquals((Object)transformedQuery, expectedTransformedQuery);
    }

    @DataProvider(name="transformableQueryProvider")
    public Iterator<Object[]> transformableQueryProvider() {
        this.setExpandedDiseaseEntities();
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        Query query = new QueryImpl().eq("expandAttribute", (Object)"disease");
        Query expected = new QueryImpl().in("expandAttribute", this.expandedDiseaseEntities);
        dataList.add(new Object[]{query, expected});
        query = new QueryImpl().in("expandAttribute", Collections.singletonList("disease"));
        expected = new QueryImpl().in("expandAttribute", this.expandedDiseaseEntities);
        dataList.add(new Object[]{query, expected});
        query = new QueryImpl().in("expandAttribute", Arrays.asList("disease", "disease2"));
        expected = new QueryImpl().in("expandAttribute", this.expandedDiseaseEntities);
        dataList.add(new Object[]{query, expected});
        query = new QueryImpl().in("expandAttribute", Arrays.asList("disease", "unknown disease"));
        expected = new QueryImpl().in("expandAttribute", this.expandedDiseaseEntities);
        dataList.add(new Object[]{query, expected});
        query = new QueryImpl().eq("expandAttribute", (Object)"disease").and().eq("otherAttr", (Object)"test");
        expected = new QueryImpl().in("expandAttribute", this.expandedDiseaseEntities).and().eq("otherAttr", (Object)"test");
        dataList.add(new Object[]{query, expected});
        query = new QueryImpl().in("expandAttribute", Collections.singletonList("disease")).or().in("otherAttr", Collections.singletonList("test"));
        expected = new QueryImpl().in("expandAttribute", this.expandedDiseaseEntities).or().in("otherAttr", Collections.singletonList("test"));
        dataList.add(new Object[]{query, expected});
        query = new QueryImpl().in("expandAttribute", Collections.singletonList("disease")).and().search("test");
        expected = new QueryImpl().in("expandAttribute", this.expandedDiseaseEntities).and().search("test");
        dataList.add(new Object[]{query, expected});
        return dataList.iterator();
    }

    @Test(dataProvider="transformableQueryProvider")
    public void testTransformableQueries(Query<Entity> query, Query<Entity> expectedTransformedQuery) {
        Mockito.when((Object)this.dataService.findAll((String)ArgumentMatchers.eq((Object)"icd10Entity"), (Stream)ArgumentMatchers.any(Stream.class))).thenReturn(Stream.of(this.diseaseEntity));
        Mockito.when((Object)this.icd10ClassExpander.expandClasses(Collections.singletonList(this.diseaseEntity))).thenReturn(this.expandedDiseaseEntities);
        Query transformedQuery = this.collectionsQueryTransformerImpl.transformQuery(query, "icd10Entity", "expandAttribute");
        Assert.assertEquals((Object)transformedQuery, expectedTransformedQuery);
    }
}

