/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.icd10;

import java.util.stream.Stream;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.icd10.CollectionsQueryTransformer;
import org.molgenis.data.icd10.Icd10ExpanderDecorator;
import org.molgenis.test.AbstractMockitoTest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class Icd10ExpanderDecoratorTest
extends AbstractMockitoTest {
    static final String ICD10_ENTITY_TYPE_ID = "icd10Entity";
    static final String EXPAND_ATTRIBUTE = "expandAttribute";
    @Mock
    private Repository<Entity> decoratedRepository;
    @Mock
    private CollectionsQueryTransformer queryTransformer;
    @Mock
    private Query<Entity> query;
    @Mock
    private Query<Entity> transformedQuery;
    private Icd10ExpanderDecorator icd10ExpanderDecorator;

    @BeforeMethod
    public void setUpBeforeMethod() {
        Mockito.when((Object)this.queryTransformer.transformQuery(this.query, ICD10_ENTITY_TYPE_ID, EXPAND_ATTRIBUTE)).thenReturn(this.transformedQuery);
        this.icd10ExpanderDecorator = new Icd10ExpanderDecorator(this.decoratedRepository, this.queryTransformer, ICD10_ENTITY_TYPE_ID, EXPAND_ATTRIBUTE);
    }

    @Test
    public void testCount() {
        Mockito.when((Object)this.decoratedRepository.count(this.transformedQuery)).thenReturn((Object)123L);
        Assert.assertEquals((long)this.icd10ExpanderDecorator.count(this.query), (long)123L);
    }

    @Test
    public void testFindOne() {
        Entity entity = (Entity)Mockito.mock(Entity.class);
        Mockito.when((Object)this.decoratedRepository.findOne(this.transformedQuery)).thenReturn((Object)entity);
        Assert.assertEquals((Object)this.icd10ExpanderDecorator.findOne(this.query), (Object)entity);
    }

    @Test
    public void testFindAll() {
        Stream entities = Stream.empty();
        Mockito.when((Object)this.decoratedRepository.findAll(this.transformedQuery)).thenReturn(entities);
        Assert.assertEquals((Object)this.icd10ExpanderDecorator.findAll(this.query), entities);
    }
}

