/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.icd10;

import com.google.common.collect.TreeTraverser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.icd10.CollectionsQueryTransformer;
import org.molgenis.data.icd10.Icd10ClassExpander;
import org.springframework.stereotype.Component;

@Component
public class CollectionsQueryTransformerImpl
implements CollectionsQueryTransformer {
    private static final TreeTraverser<QueryRule> RULE_TRAVERSER = TreeTraverser.using(QueryRule::getNestedRules);
    private final Icd10ClassExpander icd10ClassExpander;
    private final DataService dataService;

    CollectionsQueryTransformerImpl(Icd10ClassExpander icd10ClassExpander, DataService dataService) {
        this.icd10ClassExpander = Objects.requireNonNull(icd10ClassExpander);
        this.dataService = Objects.requireNonNull(dataService);
    }

    @Override
    public Query<Entity> transformQuery(Query<Entity> query, String icd10EntityTypeId, String expandAttribute) {
        if (query != null && query.getRules() != null && !query.getRules().isEmpty()) {
            query.getRules().forEach(rule -> RULE_TRAVERSER.preOrderTraversal(rule).filter(nestedRule -> this.isTransformableRule((QueryRule)nestedRule, expandAttribute)).forEach(nestedRule -> this.transformQueryRule((QueryRule)nestedRule, icd10EntityTypeId)));
        }
        return query;
    }

    private void transformQueryRule(QueryRule rule, String icd10EntityTypeId) {
        List queryValues;
        switch (rule.getOperator()) {
            case EQUALS: {
                queryValues = Collections.singletonList(rule.getValue());
                rule.setOperator(QueryRule.Operator.IN);
                break;
            }
            case IN: {
                queryValues = (List)rule.getValue();
                break;
            }
            default: {
                throw new IllegalStateException("Can't expand queries other than IN or EQUALS");
            }
        }
        List<Entity> diseaseTypes = this.dataService.findAll(icd10EntityTypeId, queryValues.stream()).collect(Collectors.toList());
        rule.setValue(this.expandDiseaseTypes(diseaseTypes));
    }

    private boolean isTransformableRule(QueryRule nestedRule, String expandAttribute) {
        return nestedRule != null && nestedRule.getField() != null && nestedRule.getField().equals(expandAttribute) && (nestedRule.getOperator() == QueryRule.Operator.IN || nestedRule.getOperator() == QueryRule.Operator.EQUALS);
    }

    private Collection<Entity> expandDiseaseTypes(List<Entity> diseaseTypes) {
        return this.icd10ClassExpander.expandClasses(diseaseTypes);
    }
}

