/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.icd10;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.mockito.Mockito;
import org.molgenis.data.Entity;
import org.molgenis.data.icd10.Icd10ClassExpanderImpl;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class Icd10ClassExpanderImplTest {
    private Icd10ClassExpanderImpl icd10ClassExpanderImpl;

    @BeforeMethod
    public void setUp() {
        this.icd10ClassExpanderImpl = new Icd10ClassExpanderImpl();
    }

    @DataProvider(name="testExpandClassesProvider")
    public static Iterator<Object[]> testExpandClassesProvider() {
        Entity entityA = Icd10ClassExpanderImplTest.createEntity("A");
        Entity entityB = Icd10ClassExpanderImplTest.createEntity("B");
        Entity entityC = Icd10ClassExpanderImplTest.createEntity("C");
        Entity entityD = Icd10ClassExpanderImplTest.createEntity("D");
        Entity entityE = Icd10ClassExpanderImplTest.createEntity("E");
        Entity entityF = Icd10ClassExpanderImplTest.createEntity("F");
        Entity entityG = Icd10ClassExpanderImplTest.createEntity("G");
        Mockito.when((Object)entityA.getEntities("children")).thenReturn(Arrays.asList(entityB, entityC));
        Mockito.when((Object)entityB.getEntities("children")).thenReturn(Arrays.asList(entityD, entityE));
        Mockito.when((Object)entityC.getEntities("children")).thenReturn(Arrays.asList(entityF, entityG));
        ArrayList<Object[]> dataList = new ArrayList<Object[]>();
        dataList.add(new Object[]{Collections.singleton(entityA), Arrays.asList(entityA, entityB, entityC, entityD, entityE, entityF, entityG)});
        dataList.add(new Object[]{Collections.singleton(entityB), Arrays.asList(entityB, entityD, entityE)});
        dataList.add(new Object[]{Collections.singleton(entityC), Arrays.asList(entityC, entityF, entityG)});
        dataList.add(new Object[]{Collections.singleton(entityD), Collections.singleton(entityD)});
        dataList.add(new Object[]{Collections.singleton(entityE), Collections.singleton(entityE)});
        dataList.add(new Object[]{Collections.singleton(entityF), Collections.singleton(entityF)});
        dataList.add(new Object[]{Collections.singleton(entityG), Collections.singleton(entityG)});
        dataList.add(new Object[]{Arrays.asList(entityA, entityB), Arrays.asList(entityA, entityB, entityC, entityD, entityE, entityF, entityG)});
        dataList.add(new Object[]{Arrays.asList(entityB, entityC), Arrays.asList(entityB, entityC, entityD, entityE, entityF, entityG)});
        dataList.add(new Object[]{Arrays.asList(entityD, entityE), Arrays.asList(entityD, entityE)});
        dataList.add(new Object[]{Arrays.asList(entityB, entityD), Arrays.asList(entityB, entityD, entityE)});
        return dataList.iterator();
    }

    @Test(dataProvider="testExpandClassesProvider")
    public void testExpandClasses(Collection<Entity> diseaseClasses, Collection<Entity> expectedExpandedDiseaseClasses) {
        Collection expandedDiseaseClasses = this.icd10ClassExpanderImpl.expandClasses(diseaseClasses);
        Assert.assertEquals((Set)Sets.newHashSet((Iterable)expandedDiseaseClasses), (Set)Sets.newHashSet(expectedExpandedDiseaseClasses));
    }

    private static Entity createEntity(String idValue) {
        Entity entity = (Entity)Mockito.when((Object)((Entity)Mockito.mock(Entity.class)).getIdValue()).thenReturn((Object)idValue).getMock();
        Mockito.when((Object)entity.getEntities("children")).thenReturn(Collections.emptyList());
        Mockito.when((Object)entity.toString()).thenReturn((Object)idValue);
        return entity;
    }
}

