/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.icd10;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.TreeTraverser;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.molgenis.data.Entity;
import org.molgenis.data.icd10.Icd10ClassExpander;
import org.springframework.stereotype.Component;

@Component
public class Icd10ClassExpanderImpl
implements Icd10ClassExpander {
    private static final String DISEASE_CLASS_CHILDREN_ATTRIBUTE_NAME = "children";

    @Override
    public Collection<Entity> expandClasses(Collection<Entity> diseaseClasses) {
        return diseaseClasses.stream().flatMap(this::expandClass).map(this::toDiseaseClass).distinct().map(this::toEntity).collect(Collectors.toList());
    }

    private Stream<Entity> expandClass(Entity diseaseClass) {
        FluentIterable diseaseClasses = new DiseaseClassTreeTraverser().postOrderTraversal(diseaseClass);
        return StreamSupport.stream(diseaseClasses.spliterator(), false);
    }

    private DiseaseClass toDiseaseClass(Entity entity) {
        return new DiseaseClass(entity);
    }

    private Entity toEntity(DiseaseClass diseaseClass) {
        return diseaseClass.getEntity();
    }

    private static class DiseaseClassTreeTraverser
    extends TreeTraverser<Entity> {
        private DiseaseClassTreeTraverser() {
        }

        public Iterable<Entity> children(@Nonnull Entity diseaseClassEntity) {
            return diseaseClassEntity.getEntities(Icd10ClassExpanderImpl.DISEASE_CLASS_CHILDREN_ATTRIBUTE_NAME);
        }
    }

    private static class DiseaseClass {
        private final Entity entity;

        private DiseaseClass(Entity entity) {
            this.entity = entity;
        }

        private Entity getEntity() {
            return this.entity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiseaseClass that = (DiseaseClass)o;
            return this.entity.getIdValue().equals(that.entity.getIdValue());
        }

        public int hashCode() {
            return this.entity.getIdValue().hashCode();
        }
    }
}

