/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.icd10;

import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.aggregation.AggregateQuery;
import org.molgenis.data.aggregation.AggregateResult;
import org.molgenis.data.icd10.CollectionsQueryTransformer;
import org.molgenis.data.support.AggregateQueryImpl;

class Icd10ExpanderDecorator
extends AbstractRepositoryDecorator<Entity> {
    private final CollectionsQueryTransformer queryTransformer;
    private final String icd10EntityTypeId;
    private final String expandAttribute;

    Icd10ExpanderDecorator(Repository<Entity> delegateRepository, CollectionsQueryTransformer queryTransformer, String icd10EntityTypeId, String expandAttribute) {
        super(delegateRepository);
        this.queryTransformer = Objects.requireNonNull(queryTransformer);
        this.icd10EntityTypeId = Objects.requireNonNull(icd10EntityTypeId);
        this.expandAttribute = Objects.requireNonNull(expandAttribute);
    }

    public long count(Query<Entity> query) {
        query = query != null ? this.transformQuery(query) : null;
        return this.delegate().count(query);
    }

    public Entity findOne(Query<Entity> query) {
        query = query != null ? this.transformQuery(query) : null;
        return this.delegate().findOne(query);
    }

    public Stream<Entity> findAll(Query<Entity> query) {
        query = query != null ? this.transformQuery(query) : null;
        return this.delegate().findAll(query);
    }

    public AggregateResult aggregate(AggregateQuery aggregateQuery) {
        Query q = aggregateQuery.getQuery();
        Query<Entity> transformedQuery = q != null ? this.transformQuery((Query<Entity>)q) : null;
        aggregateQuery = new AggregateQueryImpl(aggregateQuery.getAttributeX(), aggregateQuery.getAttributeY(), aggregateQuery.getAttributeDistinct(), transformedQuery);
        return this.delegate().aggregate(aggregateQuery);
    }

    private Query<Entity> transformQuery(Query<Entity> query) {
        return this.queryTransformer.transformQuery(query, this.icd10EntityTypeId, this.expandAttribute);
    }
}

