/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.icd10;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import java.util.Map;
import java.util.Objects;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.decorator.DynamicRepositoryDecoratorFactory;
import org.molgenis.data.icd10.CollectionsQueryTransformer;
import org.molgenis.data.icd10.Icd10ExpanderDecorator;
import org.springframework.stereotype.Component;

@Component
public class Icd10ExpanderDecoratorFactory
implements DynamicRepositoryDecoratorFactory<Entity> {
    private static final String ID = "icd10expander";
    private static final String ICD10_ENTITY_TYPE_ID = "icd10EntityTypeId";
    private static final String EXPAND_ATTRIBUTE = "expandAttribute";
    private final Gson gson;
    private final CollectionsQueryTransformer queryTransformer;

    public Icd10ExpanderDecoratorFactory(Gson gson, CollectionsQueryTransformer queryTransformer) {
        this.gson = Objects.requireNonNull(gson);
        this.queryTransformer = Objects.requireNonNull(queryTransformer);
    }

    public Repository<Entity> createDecoratedRepository(Repository<Entity> repository, Map<String, Object> parameters) {
        return new Icd10ExpanderDecorator(repository, this.queryTransformer, parameters.get(ICD10_ENTITY_TYPE_ID).toString(), parameters.get(EXPAND_ATTRIBUTE).toString());
    }

    public String getId() {
        return ID;
    }

    public String getLabel() {
        return "ICD-10 Query Expander";
    }

    public String getDescription() {
        return "Expands queries on an attribute that refers to an entity type with ICD-10 codes.";
    }

    public String getSchema() {
        return this.gson.toJson((Object)ImmutableMap.of((Object)"title", (Object)"Icd10Expander", (Object)"type", (Object)"object", (Object)"properties", (Object)ImmutableMap.of((Object)ICD10_ENTITY_TYPE_ID, (Object)ImmutableMap.of((Object)"type", (Object)"string", (Object)"description", (Object)"The entity type containing the ICD-10 data."), (Object)EXPAND_ATTRIBUTE, (Object)ImmutableMap.of((Object)"type", (Object)"string", (Object)"description", (Object)"The attribute on which the query expansion will be applied.")), (Object)"required", (Object)ImmutableList.of((Object)ICD10_ENTITY_TYPE_ID, (Object)EXPAND_ATTRIBUTE)));
    }
}

