/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.idcard.client;

import autovalue.shaded.com.google.common.common.primitives.Ints;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.idcard.client.IdCardClient;
import org.molgenis.data.idcard.mapper.IdCardBiobankMapper;
import org.molgenis.data.idcard.model.IdCardBiobank;
import org.molgenis.data.idcard.model.IdCardOrganization;
import org.molgenis.data.idcard.settings.IdCardIndexerSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IdCardClientImpl
implements IdCardClient {
    private static final Logger LOG = LoggerFactory.getLogger(IdCardClientImpl.class);
    private final HttpClient httpClient;
    private final IdCardIndexerSettings idCardIndexerSettings;
    private final IdCardBiobankMapper idCardBiobankMapper;

    @Autowired
    public IdCardClientImpl(HttpClient httpClient, IdCardIndexerSettings idCardIndexerSettings, IdCardBiobankMapper idCardBiobankMapper) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.idCardIndexerSettings = Objects.requireNonNull(idCardIndexerSettings);
        this.idCardBiobankMapper = Objects.requireNonNull(idCardBiobankMapper);
    }

    @Override
    public Entity getIdCardBiobank(String id) {
        return this.getIdCardBiobank(id, this.idCardIndexerSettings.getApiTimeout());
    }

    @Override
    public Entity getIdCardBiobank(String id, long timeout) {
        StringBuilder uriBuilder = new StringBuilder().append(this.idCardIndexerSettings.getApiBaseUri()).append('/').append(this.idCardIndexerSettings.getBiobankResource()).append('/').append(id);
        return (Entity)this.getIdCardResource(uriBuilder.toString(), new JsonResponseHandler<IdCardBiobank>(){

            @Override
            public IdCardBiobank deserialize(JsonReader jsonReader) throws IOException {
                return IdCardClientImpl.this.idCardBiobankMapper.toIdCardBiobank(jsonReader);
            }
        }, timeout);
    }

    @Override
    public Iterable<Entity> getIdCardBiobanks(Iterable<String> ids) {
        return this.getIdCardBiobanks(ids, this.idCardIndexerSettings.getApiTimeout());
    }

    @Override
    public Iterable<Entity> getIdCardBiobanks(Iterable<String> ids, long timeout) {
        String value = StreamSupport.stream(ids.spliterator(), false).collect(Collectors.joining(",", "[", "]"));
        try {
            value = URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException(e1);
        }
        StringBuilder uriBuilder = new StringBuilder().append(this.idCardIndexerSettings.getApiBaseUri()).append('/').append(this.idCardIndexerSettings.getBiobankCollectionSelectionResource()).append('/').append(value);
        return this.getIdCardResource(uriBuilder.toString(), new JsonResponseHandler<Iterable<Entity>>(){

            @Override
            public Iterable<Entity> deserialize(JsonReader jsonReader) throws IOException {
                return IdCardClientImpl.this.idCardBiobankMapper.toIdCardBiobanks(jsonReader);
            }
        }, timeout);
    }

    private <T> T getIdCardResource(String url, ResponseHandler<T> responseHandler, long timeout) {
        HttpGet request = new HttpGet(url);
        request.addHeader("Content-Type", "application/json");
        if (timeout != -1L) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(Ints.checkedCast((long)timeout)).setConnectionRequestTimeout(Ints.checkedCast((long)timeout)).setSocketTimeout(Ints.checkedCast((long)timeout)).build();
            request.setConfig(requestConfig);
        }
        try {
            LOG.info("Retrieving [" + url + "]");
            return (T)this.httpClient.execute((HttpUriRequest)request, responseHandler);
        }
        catch (IOException e) {
            throw new MolgenisDataException((Throwable)e);
        }
    }

    @Override
    public Iterable<Entity> getIdCardBiobanks() {
        return this.getIdCardBiobanks(this.idCardIndexerSettings.getApiTimeout());
    }

    @Override
    public Iterable<Entity> getIdCardBiobanks(long timeout) {
        StringBuilder uriBuilder = new StringBuilder().append(this.idCardIndexerSettings.getApiBaseUri()).append('/').append(this.idCardIndexerSettings.getBiobankCollectionResource());
        final Iterable<IdCardOrganization> idCardOrganizations = this.getIdCardResource(uriBuilder.toString(), new JsonResponseHandler<Iterable<IdCardOrganization>>(){

            @Override
            public Iterable<IdCardOrganization> deserialize(JsonReader jsonReader) throws IOException {
                return IdCardClientImpl.this.idCardBiobankMapper.toIdCardOrganizations(jsonReader);
            }
        }, timeout);
        return this.getIdCardBiobanks(new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return StreamSupport.stream(idCardOrganizations.spliterator(), false).map(IdCardOrganization::getOrganizationId).iterator();
            }
        }, timeout);
    }

    private static abstract class JsonResponseHandler<T>
    implements ResponseHandler<T> {
        private JsonResponseHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() < 100 || statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new ClientProtocolException("Response contains no content");
            }
            try (JsonReader jsonReader = new JsonReader((Reader)new InputStreamReader(entity.getContent(), StandardCharsets.UTF_8));){
                T t = this.deserialize(jsonReader);
                return t;
            }
        }

        public abstract T deserialize(JsonReader var1) throws IOException;
    }
}

