/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.idcard;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.molgenis.data.AggregateQuery;
import org.molgenis.data.AggregateResult;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Fetch;
import org.molgenis.data.Query;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.elasticsearch.ElasticsearchService;
import org.molgenis.data.idcard.client.IdCardClient;
import org.molgenis.data.idcard.model.IdCardBiobank;
import org.molgenis.data.idcard.model.IdCardBiobankMetaData;
import org.molgenis.data.idcard.settings.IdCardIndexerSettings;
import org.molgenis.data.support.AbstractRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IdCardBiobankRepository
extends AbstractRepository {
    private static final Logger LOG = LoggerFactory.getLogger(IdCardBiobankRepository.class);
    private final IdCardBiobankMetaData idCardBiobankMetaData;
    private final IdCardClient idCardClient;
    private final ElasticsearchService elasticsearchService;
    private final DataService dataService;
    private final IdCardIndexerSettings idCardIndexerSettings;

    @Autowired
    public IdCardBiobankRepository(IdCardBiobankMetaData idCardBiobankMetaData, IdCardClient idCardClient, ElasticsearchService elasticsearchService, DataService dataService, IdCardIndexerSettings idCardIndexerSettings) {
        this.idCardBiobankMetaData = idCardBiobankMetaData;
        this.idCardClient = Objects.requireNonNull(idCardClient);
        this.elasticsearchService = Objects.requireNonNull(elasticsearchService);
        this.dataService = Objects.requireNonNull(dataService);
        this.idCardIndexerSettings = Objects.requireNonNull(idCardIndexerSettings);
    }

    public Iterator<Entity> iterator() {
        return this.idCardClient.getIdCardBiobanks().iterator();
    }

    public Set<RepositoryCapability> getCapabilities() {
        HashSet<RepositoryCapability> repoCapabilities = new HashSet<RepositoryCapability>();
        repoCapabilities.add(RepositoryCapability.AGGREGATEABLE);
        repoCapabilities.add(RepositoryCapability.QUERYABLE);
        return repoCapabilities;
    }

    public EntityMetaData getEntityMetaData() {
        return this.idCardBiobankMetaData;
    }

    public long count(Query q) {
        return this.elasticsearchService.count(q, this.getEntityMetaData());
    }

    public Iterable<Entity> findAll(Query q) {
        return this.elasticsearchService.search(q, this.getEntityMetaData());
    }

    public Entity findOne(Query q) {
        Iterator<Entity> it = this.findAll(q).iterator();
        return it.hasNext() ? it.next() : null;
    }

    public Entity findOne(Object id) {
        try {
            return this.idCardClient.getIdCardBiobank(id.toString());
        }
        catch (RuntimeException e) {
            return this.createErrorIdCardBiobank(id);
        }
    }

    public Entity findOne(Object id, Fetch fetch) {
        return this.findOne(id);
    }

    public Iterable<Entity> findAll(final Iterable<Object> ids) {
        try {
            return this.idCardClient.getIdCardBiobanks(Iterables.transform(ids, (Function)new Function<Object, String>(){

                public String apply(Object id) {
                    return id.toString();
                }
            }));
        }
        catch (RuntimeException e) {
            return new Iterable<Entity>(){

                @Override
                public Iterator<Entity> iterator() {
                    return StreamSupport.stream(ids.spliterator(), false).map(id -> IdCardBiobankRepository.this.createErrorIdCardBiobank(id)).iterator();
                }
            };
        }
    }

    public Iterable<Entity> findAll(Iterable<Object> ids, Fetch fetch) {
        return this.findAll(ids);
    }

    public AggregateResult aggregate(AggregateQuery aggregateQuery) {
        return this.elasticsearchService.aggregate(aggregateQuery, this.getEntityMetaData());
    }

    public void update(Entity entity) {
        throw new UnsupportedOperationException(String.format("Repository [%s] is not %s", this.getName(), RepositoryCapability.WRITABLE.toString()));
    }

    public void update(Iterable<? extends Entity> records) {
        throw new UnsupportedOperationException(String.format("Repository [%s] is not %s", this.getName(), RepositoryCapability.WRITABLE.toString()));
    }

    public void delete(Entity entity) {
        throw new UnsupportedOperationException(String.format("Repository [%s] is not %s", this.getName(), RepositoryCapability.WRITABLE.toString()));
    }

    public void delete(Iterable<? extends Entity> entities) {
        throw new UnsupportedOperationException(String.format("Repository [%s] is not %s", this.getName(), RepositoryCapability.WRITABLE.toString()));
    }

    public void deleteById(Object id) {
        throw new UnsupportedOperationException(String.format("Repository [%s] is not %s", this.getName(), RepositoryCapability.WRITABLE.toString()));
    }

    public void deleteById(Iterable<Object> ids) {
        throw new UnsupportedOperationException(String.format("Repository [%s] is not %s", this.getName(), RepositoryCapability.WRITABLE.toString()));
    }

    public void deleteAll() {
        throw new UnsupportedOperationException(String.format("Repository [%s] is not %s", this.getName(), RepositoryCapability.WRITABLE.toString()));
    }

    public void add(Entity entity) {
        throw new UnsupportedOperationException(String.format("Repository [%s] is not %s", this.getName(), RepositoryCapability.WRITABLE.toString()));
    }

    public Integer add(Iterable<? extends Entity> entities) {
        throw new UnsupportedOperationException(String.format("Repository [%s] is not %s", this.getName(), RepositoryCapability.WRITABLE.toString()));
    }

    public void flush() {
        this.elasticsearchService.flush();
    }

    public void rebuildIndex() {
        LOG.trace("Indexing ID-Card biobanks ...");
        Iterable<Entity> entities = this.idCardClient.getIdCardBiobanks(this.idCardIndexerSettings.getIndexRebuildTimeout());
        EntityMetaData entityMeta = this.getEntityMetaData();
        if (!this.elasticsearchService.hasMapping(entityMeta)) {
            this.elasticsearchService.createMappings(entityMeta);
        }
        this.elasticsearchService.index(entities, entityMeta, ElasticsearchService.IndexingMode.UPDATE);
        LOG.debug("Indexed ID-Card biobanks");
    }

    private IdCardBiobank createErrorIdCardBiobank(Object id) {
        IdCardBiobank idCardBiobank = new IdCardBiobank(this.dataService);
        idCardBiobank.set("OrganizationID", id);
        idCardBiobank.set("name", "Error loading data");
        return idCardBiobank;
    }

    public void create() {
        throw new UnsupportedOperationException(String.format("Repository [%s] is not %s", this.getName(), RepositoryCapability.MANAGABLE.toString()));
    }

    public void drop() {
        throw new UnsupportedOperationException(String.format("Repository [%s] is not %s", this.getName(), RepositoryCapability.MANAGABLE.toString()));
    }
}

