/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.idcard.settings;

import org.molgenis.MolgenisFieldTypes;
import org.molgenis.data.idcard.settings.IdCardIndexerSettings;
import org.molgenis.data.settings.DefaultSettingsEntity;
import org.molgenis.data.settings.DefaultSettingsEntityMetaData;
import org.springframework.stereotype.Component;

@Component
public class IdCardIndexerDbSettings
extends DefaultSettingsEntity
implements IdCardIndexerSettings {
    private static final long serialVersionUID = 1L;
    private static final String ID = "idcardindexer";

    public IdCardIndexerDbSettings() {
        super(ID);
    }

    @Override
    public String getApiBaseUri() {
        return this.getString("apiBaseUri");
    }

    @Override
    public void setApiBaseUri(String apiBaseUri) {
        this.set("apiBaseUri", apiBaseUri);
    }

    @Override
    public long getApiTimeout() {
        return this.getLong("apiTimeout");
    }

    @Override
    public void setApiTimeout(long timeout) {
        this.set("apiTimeout", timeout);
    }

    @Override
    public String getBiobankResource() {
        return this.getString("biobankResource");
    }

    @Override
    public void setBiobankResource(String biobankResource) {
        this.set("biobankResource", biobankResource);
    }

    @Override
    public String getBiobankCollectionResource() {
        return this.getString("biobankCollResource");
    }

    @Override
    public void setBiobankCollectionResource(String biobankCollectionResource) {
        this.set("biobankCollResource", biobankCollectionResource);
    }

    @Override
    public String getBiobankCollectionSelectionResource() {
        return this.getString("biobankCollSelResource");
    }

    @Override
    public void setBiobankCollectionSelectionResource(String biobankCollectionSelectionResource) {
        this.set("biobankCollSelResource", biobankCollectionSelectionResource);
    }

    @Override
    public boolean getBiobankIndexingEnabled() {
        Boolean enableBiobankIndexing = this.getBoolean("biobankIndexingEnabled");
        return enableBiobankIndexing != null ? enableBiobankIndexing : false;
    }

    @Override
    public void setBiobankIndexingEnabled(boolean biobankIndexing) {
        this.set("biobankIndexingEnabled", biobankIndexing);
    }

    @Override
    public String getBiobankIndexingFrequency() {
        return this.getString("biobankIndexingFrequency");
    }

    @Override
    public void setBiobankIndexingFrequency(String cronExpression) {
        this.set("biobankIndexingFrequency", cronExpression);
    }

    @Override
    public String getNotificationEmail() {
        return this.getString("notificationEmail");
    }

    @Override
    public void setNotificationEmail(String notificationEmail) {
        this.set("notificationEmail", notificationEmail);
    }

    @Override
    public void setIndexRebuildTimeout(long timeout) {
        this.set("biobankIndexingTimeout", timeout);
    }

    @Override
    public long getIndexRebuildTimeout() {
        return this.getLong("biobankIndexingTimeout");
    }

    @Component
    private static class Meta
    extends DefaultSettingsEntityMetaData {
        private static final String CRON_REGEX = "/^\\s*($|#|\\w+\\s*=|(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?(?:,(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?)*)\\s+(\\?|\\*|(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?(?:,(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?)*)\\s+(\\?|\\*|(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?(?:,(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?)*|\\?|\\*|(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?(?:,(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?)*)\\s+(\\?|\\*|(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?(?:,(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?)*|\\?|\\*|(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?(?:,(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?)*)(|\\s)+(\\?|\\*|(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?(?:,(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?)*))$/";
        private static final String API_BASE_URI = "apiBaseUri";
        private static final String API_TIMEOUT = "apiTimeout";
        private static final String BIOBANK_RESOURCE = "biobankResource";
        private static final String BIOBANK_COLLECTIONS_RESOURCE = "biobankCollResource";
        private static final String BIOBANK_COLLECTIONS_SELECTION_RESOURCE = "biobankCollSelResource";
        private static final String BIOBANK_INDEXING_ENABLED = "biobankIndexingEnabled";
        private static final String BIOBANK_INDEXING_TIMEOUT = "biobankIndexingTimeout";
        private static final String NOTIFICATION_EMAIL = "notificationEmail";
        private static final String BIOBANK_INDEXING_FREQUENCY = "biobankIndexingFrequency";
        private static final String DEFAULT_API_BASE_URI = "http://catalogue.rd-connect.eu/api/jsonws/BiBBoxCommonServices-portlet.logapi";
        private static final long DEFAULT_API_TIMEOUT = 5000L;
        private static final String DEFAULT_BIOBANK_RESOURCE = "regbb/organization-id";
        private static final String DEFAULT_BIOBANK_COLLECTIONS_RESOURCE = "regbbs";
        private static final String DEFAULT_BIOBANK_COLLECTIONS_SELECTION_RESOURCE = "regbbs/data";
        private static final boolean DEFAULT_BIOBANK_INDEXING_ENABLED = false;
        private static final long DEFAULT_BIOBANK_INDEXING_TIMEOUT = 60000L;
        private static final String DEFAULT_BIOBANK_INDEXING_FREQUENCY = "0 4 * * * ?";
        private static final String DEFAULT_NOTIFICATION_EMAIL = "molgenis+idcard@gmail.com";

        public Meta() {
            super(IdCardIndexerDbSettings.ID);
            this.setLabel("ID-Card biobank indexer settings");
            this.addAttribute(API_BASE_URI).setDataType(MolgenisFieldTypes.STRING).setLabel("API base URI").setDefaultValue(DEFAULT_API_BASE_URI);
            this.addAttribute(API_TIMEOUT).setDataType(MolgenisFieldTypes.LONG).setLabel("API timeout").setDefaultValue(Long.toString(5000L));
            this.addAttribute(BIOBANK_RESOURCE).setDataType(MolgenisFieldTypes.STRING).setLabel("Biobank resource").setDefaultValue(DEFAULT_BIOBANK_RESOURCE);
            this.addAttribute(BIOBANK_COLLECTIONS_RESOURCE).setDataType(MolgenisFieldTypes.STRING).setLabel("Biobank collection resource").setDefaultValue(DEFAULT_BIOBANK_COLLECTIONS_RESOURCE);
            this.addAttribute(BIOBANK_COLLECTIONS_SELECTION_RESOURCE).setDataType(MolgenisFieldTypes.STRING).setLabel("Biobank collection filtered resource").setDefaultValue(DEFAULT_BIOBANK_COLLECTIONS_SELECTION_RESOURCE);
            this.addAttribute(BIOBANK_INDEXING_ENABLED).setDataType(MolgenisFieldTypes.BOOL).setLabel("Biobank indexing enabled").setDefaultValue(Boolean.toString(false)).setNillable(false);
            this.addAttribute(BIOBANK_INDEXING_TIMEOUT).setDataType(MolgenisFieldTypes.LONG).setLabel("Biobank indexing timeout").setDefaultValue(Long.toString(60000L)).setNillable(false);
            this.addAttribute(BIOBANK_INDEXING_FREQUENCY).setDataType(MolgenisFieldTypes.STRING).setLabel("Biobank indexing frequency").setDescription("Cron expression (e.g. 0 4 * * * ?)").setDefaultValue(DEFAULT_BIOBANK_INDEXING_FREQUENCY).setNillable(false).setVisibleExpression("$('biobankIndexingEnabled').eq(true).value()").setValidationExpression("$('biobankIndexingFrequency').matches(/^\\s*($|#|\\w+\\s*=|(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?(?:,(?:[0-5]?\\d)(?:(?:-|\\/|\\,)(?:[0-5]?\\d))?)*)\\s+(\\?|\\*|(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?(?:,(?:[01]?\\d|2[0-3])(?:(?:-|\\/|\\,)(?:[01]?\\d|2[0-3]))?)*)\\s+(\\?|\\*|(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?(?:,(?:0?[1-9]|[12]\\d|3[01])(?:(?:-|\\/|\\,)(?:0?[1-9]|[12]\\d|3[01]))?)*)\\s+(\\?|\\*|(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?(?:,(?:[1-9]|1[012])(?:(?:-|\\/|\\,)(?:[1-9]|1[012]))?(?:L|W)?)*|\\?|\\*|(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?(?:,(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)(?:(?:-)(?:JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC))?)*)\\s+(\\?|\\*|(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?(?:,(?:[0-6])(?:(?:-|\\/|\\,|#)(?:[0-6]))?(?:L)?)*|\\?|\\*|(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?(?:,(?:MON|TUE|WED|THU|FRI|SAT|SUN)(?:(?:-)(?:MON|TUE|WED|THU|FRI|SAT|SUN))?)*)(|\\s)+(\\?|\\*|(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?(?:,(?:|\\d{4})(?:(?:-|\\/|\\,)(?:|\\d{4}))?)*))$/).value()");
            this.addAttribute(NOTIFICATION_EMAIL).setDataType(MolgenisFieldTypes.EMAIL).setLabel("Notification email").setDescription("email address used for index failure notifications").setDefaultValue(DEFAULT_NOTIFICATION_EMAIL);
        }
    }
}

