/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.idcard;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.molgenis.data.AttributeMetaData;
import org.molgenis.data.DataService;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.ManageableRepositoryCollection;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Repository;
import org.molgenis.data.UnknownAttributeException;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.idcard.IdCardBiobankRepository;
import org.molgenis.data.support.DefaultEntityMetaData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IdCardRepositoryCollection
implements ManageableRepositoryCollection {
    public static final String NAME = "ID-Card";
    private final DataService dataService;
    private final IdCardBiobankRepository idCardBiobankRepository;
    private final Map<String, Repository> repositories;

    @Autowired
    public IdCardRepositoryCollection(DataService dataService, IdCardBiobankRepository idCardBiobankRepository) {
        this.dataService = Objects.requireNonNull(dataService);
        this.idCardBiobankRepository = Objects.requireNonNull(idCardBiobankRepository);
        this.repositories = Maps.newLinkedHashMap();
    }

    public String getName() {
        return NAME;
    }

    public Repository addEntityMeta(EntityMetaData entityMeta) {
        String entityName = entityMeta.getName();
        if (!entityName.equals("rdconnect_regbb")) {
            throw new MolgenisDataException("Not a valid backend for entity [" + entityName + "]");
        }
        if (this.repositories.containsKey("rdconnect_regbb")) {
            throw new MolgenisDataException("ID-Card repository collection already contains repository [" + entityName + "]");
        }
        this.repositories.put("rdconnect_regbb", (Repository)this.idCardBiobankRepository);
        return this.idCardBiobankRepository;
    }

    public Iterable<String> getEntityNames() {
        return this.repositories.keySet();
    }

    public Repository getRepository(String name) {
        return this.repositories.get(name);
    }

    public boolean hasRepository(String name) {
        return this.repositories.containsKey(name);
    }

    public Iterator<Repository> iterator() {
        return this.repositories.values().iterator();
    }

    public void deleteEntityMeta(String entityName) {
        this.repositories.remove(entityName);
    }

    public void addAttribute(String entityName, AttributeMetaData attribute) {
        DefaultEntityMetaData entityMetaData;
        try {
            entityMetaData = (DefaultEntityMetaData)this.dataService.getEntityMetaData(entityName);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("Cannot cast EntityMetaData to DefaultEntityMetadata " + ex);
        }
        if (entityMetaData == null) {
            throw new UnknownEntityException(String.format("Unknown entity '%s'", entityName));
        }
        entityMetaData.addAttributeMetaData(attribute);
    }

    public void deleteAttribute(String entityName, String attributeName) {
        EntityMetaData entityMetaData = this.dataService.getMeta().getEntityMetaData(entityName);
        if (entityMetaData == null) {
            throw new UnknownEntityException(String.format("Unknown entity '%s'", entityName));
        }
        DefaultEntityMetaData defaultEntityMetaData = new DefaultEntityMetaData(this.dataService.getMeta().getEntityMetaData(entityName));
        AttributeMetaData attr = entityMetaData.getAttribute(attributeName);
        if (attr == null) {
            throw new UnknownAttributeException(String.format("Unknown attribute '%s' of entity '%s'", attributeName, entityName));
        }
        defaultEntityMetaData.removeAttributeMetaData(attr);
    }

    public void addAttributeSync(String entityName, AttributeMetaData attribute) {
        this.addAttribute(entityName, attribute);
    }
}

