/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.idcard.indexer;

import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.UUID;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.idcard.indexer.IdCardIndexerJob;
import org.molgenis.data.idcard.indexer.IdCardIndexerService;
import org.molgenis.data.idcard.model.IdCardIndexingEvent;
import org.molgenis.data.idcard.model.IdCardIndexingEventStatus;
import org.molgenis.data.idcard.settings.IdCardIndexerSettings;
import org.molgenis.data.settings.SettingsEntityListener;
import org.molgenis.security.core.runas.RunAsSystemProxy;
import org.molgenis.security.core.utils.SecurityUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;

@Service
public class IdCardIndexerServiceImpl
implements IdCardIndexerService,
DisposableBean,
ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(IdCardIndexerServiceImpl.class);
    private static final String TRIGGER_GROUP = "idcard";
    private static final String JOB_GROUP = "idcard";
    private static final String INDEX_REBUILD_JOB_KEY = "indexRebuild";
    private final DataService dataService;
    private final IdCardIndexerSettings idCardIndexerSettings;
    private final Scheduler scheduler;
    private final String triggerNameSalt;
    private final String triggerNameScheduled;

    @Autowired
    public IdCardIndexerServiceImpl(DataService dataService, IdCardIndexerSettings idCardBiobankIndexerSettings, Scheduler scheduler) {
        this.dataService = Objects.requireNonNull(dataService);
        this.idCardIndexerSettings = Objects.requireNonNull(idCardBiobankIndexerSettings);
        this.scheduler = Objects.requireNonNull(scheduler);
        this.triggerNameSalt = UUID.randomUUID().toString();
        this.triggerNameScheduled = UUID.randomUUID().toString();
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.idCardIndexerSettings.addListener(new SettingsEntityListener(){

            public void postUpdate(Entity entity) {
                try {
                    IdCardIndexerServiceImpl.this.updateIndexerScheduler(false);
                }
                catch (SchedulerException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        try {
            this.updateIndexerScheduler(true);
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TriggerKey scheduleIndexRebuild() throws SchedulerException {
        TriggerKey triggerKey = this.getIndexRebuildTriggerKeyCurrentUser();
        if (this.scheduler.checkExists(triggerKey)) {
            throw new RuntimeException("Index rebuild already scheduled");
        }
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(triggerKey).usingJobData("username", SecurityUtils.getCurrentUsername()).startNow();
        this.scheduleIndexRebuildJob(triggerBuilder);
        return triggerKey;
    }

    @Override
    public Trigger.TriggerState getIndexRebuildStatus(TriggerKey triggerKey) throws SchedulerException {
        return this.scheduler.getTriggerState(triggerKey);
    }

    public void destroy() throws Exception {
        LOG.debug("Stopping scheduler (waiting for jobs to complete) ...");
        boolean waitForJobsToComplete = true;
        this.scheduler.shutdown(waitForJobsToComplete);
        LOG.info("Scheduler stopped");
    }

    private TriggerKey getIndexRebuildTriggerKeyCurrentUser() {
        MessageDigest messageDigest;
        String rawTriggerName = this.triggerNameSalt + SecurityUtils.getCurrentUsername();
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        byte[] md5Hash = messageDigest.digest(rawTriggerName.getBytes(StandardCharsets.UTF_8));
        String triggerName = BaseEncoding.base64Url().omitPadding().encode(md5Hash);
        return new TriggerKey(triggerName, "idcard");
    }

    private JobKey getIndexRebuildJobKey() {
        return new JobKey(INDEX_REBUILD_JOB_KEY, "idcard");
    }

    private JobKey scheduleIndexRebuildJob(TriggerBuilder<?> triggerBuilder) throws SchedulerException {
        JobKey jobKey = this.getIndexRebuildJobKey();
        JobDetail jobDetail = this.scheduler.getJobDetail(jobKey);
        if (jobDetail == null) {
            jobDetail = JobBuilder.newJob(IdCardIndexerJob.class).withIdentity(jobKey).build();
            this.scheduler.scheduleJob(jobDetail, triggerBuilder.build());
        } else {
            this.scheduler.scheduleJob(triggerBuilder.forJob(jobDetail).build());
        }
        return jobKey;
    }

    private void updateIndexerScheduler(boolean initScheduler) throws SchedulerException {
        JobKey jobKey = this.getIndexRebuildJobKey();
        if (this.idCardIndexerSettings.getBiobankIndexingEnabled()) {
            String biobankIndexingFrequency = this.idCardIndexerSettings.getBiobankIndexingFrequency();
            TriggerBuilder<?> triggerBuilder = this.createCronTrigger(biobankIndexingFrequency);
            if (!this.scheduler.checkExists(jobKey)) {
                LOG.info("Scheduling index rebuild job with cron [{}]", (Object)biobankIndexingFrequency);
                this.scheduleIndexRebuildJob(triggerBuilder);
                if (!initScheduler) {
                    this.onIndexConfigurationUpdate("Indexing enabled");
                }
            } else {
                TriggerKey triggerKey = this.getIndexRebuildTriggerKeySystem();
                Trigger oldTrigger = this.scheduler.getTrigger(triggerKey);
                Trigger trigger = triggerBuilder.build();
                if (trigger instanceof CronTriggerImpl && oldTrigger instanceof CronTriggerImpl && !((CronTriggerImpl)trigger).getCronExpression().equals(((CronTriggerImpl)oldTrigger).getCronExpression())) {
                    LOG.info("Rescheduling index rebuild job with cron [{}]", (Object)biobankIndexingFrequency);
                    this.scheduler.rescheduleJob(triggerKey, trigger);
                    if (!initScheduler) {
                        String updateMessage = String.format("Indexing schedule update [%s]", biobankIndexingFrequency);
                        this.onIndexConfigurationUpdate(updateMessage);
                    }
                }
            }
        } else if (this.scheduler.checkExists(jobKey)) {
            LOG.info("Deleting index rebuild job");
            this.scheduler.deleteJob(jobKey);
            if (!initScheduler) {
                this.onIndexConfigurationUpdate("Indexing disabled");
            }
        }
    }

    private TriggerKey getIndexRebuildTriggerKeySystem() {
        return new TriggerKey(this.triggerNameScheduled, "idcard");
    }

    private TriggerBuilder<?> createCronTrigger(String cronExpression) throws SchedulerException {
        return TriggerBuilder.newTrigger().withIdentity(this.getIndexRebuildTriggerKeySystem()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression));
    }

    private void onIndexConfigurationUpdate(String updateMessage) {
        IdCardIndexingEvent idCardIndexingEvent = new IdCardIndexingEvent(this.dataService);
        idCardIndexingEvent.setStatus(IdCardIndexingEventStatus.CONFIGURATION_CHANGE);
        idCardIndexingEvent.setMessage(updateMessage);
        RunAsSystemProxy.runAsSystem(() -> this.dataService.add("IdCardIndexingEvent", (Entity)idCardIndexingEvent));
    }
}

