/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.idcard.indexer;

import java.util.Objects;
import org.molgenis.data.idcard.indexer.IdCardIndexerService;
import org.molgenis.ui.MolgenisPluginController;
import org.molgenis.util.ErrorMessageResponse;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/plugin/idcardindexer"})
public class IdCardIndexerController
extends MolgenisPluginController {
    private static final Logger LOG = LoggerFactory.getLogger(IdCardIndexerController.class);
    public static final String ID = "idcardindexer";
    public static final String URI = "/plugin/idcardindexer";
    private final IdCardIndexerService idCardIndexerService;

    @Autowired
    public IdCardIndexerController(IdCardIndexerService idCardIndexerService) {
        super(URI);
        this.idCardIndexerService = Objects.requireNonNull(idCardIndexerService);
    }

    @RequestMapping(method={RequestMethod.GET})
    @PreAuthorize(value="hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_IDCARDINDEXER')")
    public String init(Model model) throws Exception {
        model.addAttribute("id_card_biobank_registry_entity_name", (Object)"rdconnect_regbb");
        return "view-idcardbiobankindexer";
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/reindex"})
    @PreAuthorize(value="hasAnyRole('ROLE_SU, ROLE_ENTITY_WRITE_IDCARDINDEXER')")
    @ResponseBody
    public IndexRebuildStatus scheduleIndexRebuild(Model model) throws Exception {
        TriggerKey triggerKey = this.idCardIndexerService.scheduleIndexRebuild();
        Trigger.TriggerState triggerStatus = this.idCardIndexerService.getIndexRebuildStatus(triggerKey);
        return new IndexRebuildStatus(triggerKey, triggerStatus);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/status/{triggerGroup}/{triggerName}"})
    @PreAuthorize(value="hasAnyRole('ROLE_SU, ROLE_ENTITY_READ_IDCARDINDEXER')")
    @ResponseBody
    public IndexRebuildStatus getIndexRebuildStatus(@PathVariable String triggerGroup, @PathVariable String triggerName) throws Exception {
        TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroup);
        Trigger.TriggerState triggerStatus = this.idCardIndexerService.getIndexRebuildStatus(triggerKey);
        return new IndexRebuildStatus(triggerKey, triggerStatus);
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorMessageResponse handleThrowable(Throwable t) {
        LOG.error("", t);
        return new ErrorMessageResponse(new ErrorMessageResponse.ErrorMessage(t.getMessage()));
    }

    private static class IndexRebuildStatus {
        private final String triggerName;
        private final String triggerGroup;
        private final String triggerStatus;

        public IndexRebuildStatus(TriggerKey triggerKey, Trigger.TriggerState triggerStatus) {
            this.triggerName = Objects.requireNonNull(triggerKey).getName();
            this.triggerGroup = Objects.requireNonNull(triggerKey).getGroup();
            this.triggerStatus = Objects.requireNonNull(triggerStatus).toString();
        }

        public String getTriggerName() {
            return this.triggerName;
        }

        public String getTriggerGroup() {
            return this.triggerGroup;
        }

        public String getTriggerStatus() {
            return this.triggerStatus;
        }
    }
}

